/*================================================================================
	
		*****************************************
		********* [Team Semiclip 1.8.1] *********
		*****************************************
	
	----------------------
	-*- Licensing Info -*-
	----------------------
	
	Team Semiclip
	by schmurgel1983(@msn.com)
	Copyright (C) 2010 - 2011 Stefan "schmurgel1983" Focke
	
	This program is free software: you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation, either version 3 of the License, or (at your
	option) any later version.
	
	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
	Public License for more details.
	
	You should have received a copy of the GNU General Public License along
	with this program. If not, see <http://www.gnu.org/licenses/>.
	
	In addition, as a special exception, the author gives permission to
	link the code of this program with the Half-Life Game Engine ("HL
	Engine") and Modified Game Libraries ("MODs") developed by Valve,
	L.L.C ("Valve"). You must obey the GNU General Public License in all
	respects for all of the code used other than the HL Engine and MODs
	from Valve. If you modify this file, you may extend this exception
	to your version of the file, but you are not obligated to do so. If
	you do not wish to do so, delete this exception statement from your
	version.
	
	No warranties of any kind. Use at your own risk.
	
	-------------------
	-*- Description -*-
	-------------------
	
	Added Team Semiclip, only for 1 team or both with enemie trespass or not.
	If team switching in mid-round so updating the team instandly, with unstuck feature.
	
	--------------------
	-*- Requirements -*-
	--------------------
	
	* Mods: Counter-Strike 1.6, Condition-Zero or Day of Defeat 1.3
	* AMXX: Version 1.8.0 or later
	* Module: engine, fakemeta, hamsandwich
	
	----------------
	-*- Commands -*-
	----------------
	
	-----
	
	---------------------
	-*- Configuration -*-
	---------------------
	
	// General
	// -------
	semiclip 1 // Enabled 1, Disabled 0
	semiclip_blockteam 0 // Both teams have semiclip - 0, Terror/Allies don't have semiclip - 1, CT/Axis don't have semiclip - 2
	semiclip_enemies 0 // trespass enemies [0-disabled / 1-enabled]
	semiclip_unstuck 1 // Unstuck for blockteam [0-disabled / 1-enabled]
	semiclip_unstuckdelay 0.0 // Unstuck delay in seconds (0.1 - 3.0) [0-instantly]
	semiclip_button 0 // Semiclip only if holding +use button [0-disabled / 1-enabled]
	
	// Render
	// ------
	semiclip_rendermode 2 // Render mode (look amxconst.inc -> Render for set_user_rendering) [0-5] [0-disabled]
	semiclip_renderradius 250 // Render radius [0-4095]
	semiclip_renderamt 128 // Render amount [0-255]
	semiclip_renderfade 0 // Render fade [0-disabled / 1-enabled] (do not use when u have CSO models)
	semiclip_renderfademin 50 // Minimum render fade amount [0-255] (stay very close or inside a player)
	semiclip_renderfadespec 0 // Render fade for current spectating Player [0-disabled / 1-enabled]
	
	---------------
	-*- Credits -*-
	---------------
	
	* SchlumPF*: Team Semiclip (main core)
	* joaquimandrade: Module: Semiclip (some cvars)
	* ConnorMcLeod: show playersname (bugfix)
	* MeRcyLeZZ & VEN: Unstuck (function)
	* georgik57: for many suggestions :)
	
	-----------------
	-*- Changelog -*-
	-----------------
	
	* v1.0:
		- initial release
	
	* v1.1:
		- Fixed: invisible player bones... like walls
	
	* v1.2:
		- faster! lower cpu!
	
	* v1.3:
		- added: Day of Defeat support
		- fixed: show playersname
	
	* v1.4:
		- Added: 2 new cvars for render mode & amt
		- made plugin 700% faster!
	
	* v1.5:
		- Added: automatic unstuck function for blockteam,
		   unstuck delay
	
	* v1.5.1:
		- Fixed: DoD 1.3 spawn classnames
	
	* v1.6:
		- Added: team_semiclip.cfg, no one block befor
		   zp_round_started, biohazard 2.0 support,
		   clip fade only in distance range
	
	* v1.6.1:
		- Added: spectator support
		- Fixed: trespass enemies dosen't work correctly
	
	* v1.6.2:
		- Fixed: small semiclip_blockteam "0" bug after
		   first zombie is chosen
	
	* v1.6.3:
		- Rewrite: Features - No one block before first
		   zombie is chosen
	
	* v1.7.0:
		- Added: semiclip fade
		- Fixed: v1.6.3 broke bot support
	
	* v1.8.0:
		- Added: new cvars for fade minimum, radius
		   current spectating player fade and +use
		   button to get semiclip only when holding
	
	* v1.8.1:
		- Fixed: plugin is now working as intended,
		   for all scripted of amxmodx plugin's like
		   kreedz bhop maps etc
	
=================================================================================*/

#include <amxmodx>
#include <engine>
#include <fakemeta>

#if AMXX_VERSION_NUM < 180
	#assert AMX Mod X v1.8.0 or later library required!
#endif

#include <hamsandwich>

/*================================================================================
 [Constants, Offsets, Macros]
=================================================================================*/

new const PLUGIN_VERSION[] = "1.8.1"

const MAX_RENDER_AMOUNT = 255	// do not change this
const SEMI_RENDER_AMOUNT = 200	// do not change this
const Float:SPEC_INTERVAL = 0.2	// do not change this

enum
{
	MOD_CSTRIKE = 0,
	MOD_DOD
}
new g_iMod

const PEV_SPEC_TARGET = pev_iuser2
const TASK_SPECTATOR = 3128
#define ID_SPECTATOR (taskid - TASK_SPECTATOR)

/*================================================================================
 [Global Variables]
=================================================================================*/

new cvar_iSemiClip, cvar_iSemiClipEnemies, cvar_iSemiClipBlockTeams,
cvar_iSemiClipUnstuck, cvar_flSemiClipUnstuckDelay,
cvar_iSemiClipRenderMode, cvar_iSemiClipRenderRadius,
cvar_iSemiClipRenderAmt, cvar_iSemiClipRenderFade,
cvar_iSemiClipRenderFadeMin, cvar_iSemiClipRenderFadeSpec,
cvar_iSemiClipButton

new cvar_iBotQuota, cvar_iZombiePlague, cvar_iBiohazard,
bool:g_bHamCzBots, g_iMaxPlayers, bool:g_bPreparation

new g_iSpawnCount, Float:g_flSpawns[64][3], g_iSpawnCount2, Float:g_flSpawns2[64][3]

new g_iCachedSemiClip, g_iCachedEnemies, g_iCachedBlockTeams,
g_iCachedUnstuck, Float:g_flCachedUnstuckDelay,
g_iCachedRenderMode, g_iCachedRenderRadius,
g_iCachedRenderAmt, g_iCachedRenderFade,
g_iCachedRenderFadeMin, g_iCachedRenderFadeSpec,
g_iCachedClipButton

new bool:g_bIsAlive[33]
new bool:g_bIsConnected[33]
new bool:g_bIsBot[33]
new bool:g_bSolid[33]
new bool:g_bHaveSemiClip[33]
new g_iTeam[33]
new g_iSpectating[33]
new g_iSpectatingTeam[33]
new g_bButton[33]
new g_iRange[33][33]

#define is_user_valid(%1) (1 <= %1 <= g_iMaxPlayers)

/*================================================================================
 [Init and Cfg]
=================================================================================*/

public plugin_init()
{
	register_plugin("Team Semiclip", PLUGIN_VERSION, "schmurgel1983")
	
	RegisterHam(Ham_Spawn, "player", "fwd_PlayerSpawn_Post", 1)
	RegisterHam(Ham_Killed, "player", "fwd_PlayerKilled")
	RegisterHam(Ham_Player_PreThink, "player", "fwd_Player_PreThink_Post", 1)
	RegisterHam(Ham_Player_PostThink, "player", "fwd_Player_PostThink")
	
	register_forward(FM_AddToFullPack, "fwd_AddToFullPack_Post", 1)
	
	new mod[8]
	get_modname(mod, charsmax(mod))
	if (equal(mod, "cstrike") || equal(mod, "czero"))
	{
		g_iMod = MOD_CSTRIKE
		register_message(get_user_msgid("TeamInfo"), "message_TeamInfo")
	}
	if (equal(mod, "dod"))
	{
		g_iMod = MOD_DOD
		register_message(get_user_msgid("PTeam"), "message_PTeam")
	}
	
	cvar_iSemiClip = register_cvar("semiclip", "1")
	cvar_iSemiClipBlockTeams = register_cvar("semiclip_blockteam", "0")
	cvar_iSemiClipEnemies = register_cvar("semiclip_enemies", "0")
	cvar_iSemiClipUnstuck = register_cvar("semiclip_unstuck", "1")
	cvar_flSemiClipUnstuckDelay = register_cvar("semiclip_unstuckdelay", "0.0")
	cvar_iSemiClipButton = register_cvar("semiclip_button", "0")
	
	cvar_iSemiClipRenderMode = register_cvar("semiclip_rendermode", "2")
	cvar_iSemiClipRenderRadius = register_cvar("semiclip_renderradius", "250")
	cvar_iSemiClipRenderAmt = register_cvar("semiclip_renderamt", "128")
	cvar_iSemiClipRenderFade = register_cvar("semiclip_renderfade", "0")
	cvar_iSemiClipRenderFadeMin = register_cvar("semiclip_renderfademin", "50")
	cvar_iSemiClipRenderFadeSpec = register_cvar("semiclip_renderfadespec", "0")
	
	register_cvar("Team_Semiclip_version", PLUGIN_VERSION, FCVAR_SERVER|FCVAR_SPONLY)
	set_cvar_string("Team_Semiclip_version", PLUGIN_VERSION)
	
	cvar_iBotQuota = get_cvar_pointer("bot_quota")
	cvar_iZombiePlague = get_cvar_pointer("zp_on")
	cvar_iBiohazard = get_cvar_pointer("bh_enabled")
	
	if (cvar_iZombiePlague || cvar_iBiohazard)
		if (get_pcvar_num(cvar_iZombiePlague) == 1 || get_pcvar_num(cvar_iBiohazard) == 1)
			register_event("HLTV", "event_round_start", "a", "1=0", "2=0")
	
	g_iMaxPlayers = get_maxplayers()
}

public plugin_cfg()
{
	new configsdir[32]
	get_configsdir(configsdir, charsmax(configsdir))
	server_cmd("exec %s/team_semiclip.cfg", configsdir)
	
	load_spawns()
	set_task(0.5, "cache_cvars")
	set_task(12.0, "cache_cvars", _, _, _, "b")
}

public client_connect(id)
{
	g_bIsConnected[id] = false
	set_cvars(id)
}

public client_putinserver(id)
{
	g_bIsConnected[id] = true
	set_cvars(id)
	
	if(is_user_bot(id))
	{
		g_bIsBot[id] = true
		
		if(!g_bHamCzBots && cvar_iBotQuota)
			set_task(0.1, "register_ham_czbots", id)
	}
	else
	{
		set_task(SPEC_INTERVAL, "spec_check", id+TASK_SPECTATOR, _, _, "b")
	}
}

public client_disconnect(id)
{
	g_bIsConnected[id] = false
	set_cvars(id)
	remove_task(id+TASK_SPECTATOR)
}

/*================================================================================
 [Main Events]
=================================================================================*/

public event_round_start()
{
	g_bPreparation = true
}

/*================================================================================
 [Supporting Forwards]
=================================================================================*/

forward zp_round_started(gamemode, id)
public zp_round_started(gamemode, id)
{
	g_bPreparation = false
}

forward event_gamestart()
public event_gamestart()
{
	g_bPreparation = false
}

/*================================================================================
 [Main Forwards]
=================================================================================*/

public fwd_PlayerSpawn_Post(id)
{
	if (!is_user_alive(id) || !g_iTeam[id])
		return
	
	g_bIsAlive[id] = true
	remove_task(id+TASK_SPECTATOR)
}

public fwd_PlayerKilled(id)
{
	g_bIsAlive[id] = false
	g_bHaveSemiClip[id] = false
	g_iTeam[id] = 3
	
	if (!g_bIsBot[id])
		set_task(SPEC_INTERVAL, "spec_check", id+TASK_SPECTATOR, _, _, "b")
}

public fwd_Player_PreThink_Post(id)
{
	if (!g_iCachedSemiClip || !g_bIsAlive[id]) return FMRES_IGNORED
	
	if (g_iCachedClipButton)
		g_bButton[id] = (pev(id, pev_button) & IN_USE) ? true : false;
	
	static i
	for (i = 1; i <= g_iMaxPlayers; i++)
	{
		if (!g_bIsConnected[i] || !g_bIsAlive[i]) continue
		
		if (!g_bHaveSemiClip[i])
			g_bSolid[i] = true
		else
			g_bSolid[i] = false
	}
	
	if (g_bSolid[id])
		for (i = 1; i <= g_iMaxPlayers; i++)
		{
			g_iRange[id][i] = MAX_RENDER_AMOUNT
			
			if (!g_bIsConnected[i] || !g_bIsAlive[i] || !g_bSolid[i]) continue
			if (g_iCachedClipButton && !g_bButton[id]) continue
			if ((g_iRange[id][i] = calc_fade(id, i, g_iCachedRenderFade)) == MAX_RENDER_AMOUNT) continue
			if (i == id) continue
			
			if (g_bPreparation)
			{
				set_pev(i, pev_solid, SOLID_NOT)
				g_bHaveSemiClip[i] = true
				continue
			}
			
			if (g_iCachedBlockTeams == g_iTeam[i] && g_iCachedEnemies && g_iTeam[i] == g_iTeam[id]) continue
			if (g_iCachedBlockTeams == g_iTeam[i] && !g_iCachedEnemies) continue
			if (!g_iCachedEnemies && g_iTeam[i] != g_iTeam[id]) continue
			
			set_pev(i, pev_solid, SOLID_NOT)
			g_bHaveSemiClip[i] = true
		}
	
	return FMRES_IGNORED
}

public fwd_Player_PostThink(id)
{
	if (!g_bIsAlive[id]) return FMRES_IGNORED
	
	static i
	for (i = 1; i <= g_iMaxPlayers; i++)
	{
		if (!g_bIsConnected[i] || !g_bIsAlive[i]) continue
		
		if (g_bHaveSemiClip[i])
		{
			set_pev(i, pev_solid, SOLID_SLIDEBOX)
			g_bHaveSemiClip[i] = false
		}
	}
	
	return FMRES_IGNORED
}

// (struct entity_state_s *state, int e, edict_t *ent, edict_t *host, int hostflags, int player, unsigned char *pSet)
public fwd_AddToFullPack_Post(es_handle, e, ent, host, flags, player, pSet)
{
	if (!player) return FMRES_IGNORED
	if (g_iTeam[host] == 3)
	{
		if (!g_iCachedRenderMode || g_bIsBot[host] || !g_bIsAlive[g_iSpectating[host]] || !g_bIsAlive[ent]) return FMRES_IGNORED
		if (g_iCachedClipButton && !g_bButton[g_iSpectating[host]]) return FMRES_IGNORED
		if (g_iRange[g_iSpectating[host]][ent] == MAX_RENDER_AMOUNT) return FMRES_IGNORED
		if (!g_iCachedRenderFadeSpec && g_iSpectating[host] == ent) return FMRES_IGNORED
		
		if (g_bPreparation)
		{
			set_es(es_handle, ES_RenderMode, g_iCachedRenderMode)
			set_es(es_handle, ES_RenderAmt, g_iRange[g_iSpectating[host]][ent])
			
			return FMRES_IGNORED
		}
		
		if (g_iCachedBlockTeams == g_iTeam[ent] && g_iCachedEnemies && g_iTeam[ent] == g_iSpectatingTeam[host]) return FMRES_IGNORED
		if (g_iCachedBlockTeams == g_iTeam[ent] && !g_iCachedEnemies) return FMRES_IGNORED
		if (!g_iCachedEnemies && g_iTeam[ent] != g_iSpectatingTeam[host]) return FMRES_IGNORED
		
		set_es(es_handle, ES_RenderMode, g_iCachedRenderMode)
		set_es(es_handle, ES_RenderAmt, g_iRange[g_iSpectating[host]][ent])
		
		return FMRES_IGNORED
	}
	
	if (!g_bIsAlive[host] || !g_bIsAlive[ent] || !g_bSolid[host] || !g_bSolid[ent]) return FMRES_IGNORED
	if (g_iCachedClipButton && !g_bButton[host]) return FMRES_IGNORED
	if (g_iRange[host][ent] == MAX_RENDER_AMOUNT) return FMRES_IGNORED
	
	if (g_bPreparation)
	{
		set_es(es_handle, ES_Solid, SOLID_NOT)
		
		if (!g_iCachedRenderMode) return FMRES_IGNORED
		
		set_es(es_handle, ES_RenderMode, g_iCachedRenderMode)
		set_es(es_handle, ES_RenderAmt, g_iRange[host][ent])
		
		return FMRES_IGNORED
	}
	
	if (g_iCachedBlockTeams == g_iTeam[ent] && g_iCachedEnemies && g_iTeam[ent] == g_iTeam[host]) return FMRES_IGNORED
	if (g_iCachedBlockTeams == g_iTeam[ent] && !g_iCachedEnemies) return FMRES_IGNORED
	if (!g_iCachedEnemies && g_iTeam[ent] != g_iTeam[host]) return FMRES_IGNORED
	
	set_es(es_handle, ES_Solid, SOLID_NOT)
	
	if (!g_iCachedRenderMode) return FMRES_IGNORED
	
	set_es(es_handle, ES_RenderMode, g_iCachedRenderMode)
	set_es(es_handle, ES_RenderAmt, g_iRange[host][ent])
	
	return FMRES_IGNORED
}

/*================================================================================
 [Other Functions and Tasks]
=================================================================================*/

// credits to MeRcyLeZZ
public register_ham_czbots(id)
{
	if (g_bHamCzBots || !is_user_connected(id) || !get_pcvar_num(cvar_iBotQuota)) return
	
	RegisterHamFromEntity(Ham_Spawn, id, "fwd_PlayerSpawn_Post", 1)
	RegisterHamFromEntity(Ham_Killed, id, "fwd_PlayerKilled")
	RegisterHamFromEntity(Ham_Player_PreThink, id, "fwd_Player_PreThink_Post", 1)
	RegisterHamFromEntity(Ham_Player_PostThink, id, "fwd_Player_PostThink")
	
	g_bHamCzBots = true
	
	if (is_user_alive(id)) fwd_PlayerSpawn_Post(id)
}

public cache_cvars()
{
	g_iCachedSemiClip = clamp(get_pcvar_num(cvar_iSemiClip), 0, 1)
	g_iCachedEnemies = clamp(get_pcvar_num(cvar_iSemiClipEnemies), 0, 1)
	g_iCachedBlockTeams = clamp(get_pcvar_num(cvar_iSemiClipBlockTeams), 0, 2)
	g_iCachedUnstuck = clamp(get_pcvar_num(cvar_iSemiClipUnstuck), 0, 1)
	g_flCachedUnstuckDelay = floatclamp(get_pcvar_float(cvar_flSemiClipUnstuckDelay), 0.0, 3.0)
	g_iCachedClipButton = clamp(get_pcvar_num(cvar_iSemiClipButton), 0, 1)
	
	g_iCachedRenderMode = clamp(get_pcvar_num(cvar_iSemiClipRenderMode), 0, 5)
	g_iCachedRenderAmt = clamp(get_pcvar_num(cvar_iSemiClipRenderAmt), 0, 255)
	g_iCachedRenderFade = clamp(get_pcvar_num(cvar_iSemiClipRenderFade), 0, 1)
	g_iCachedRenderFadeMin = clamp(get_pcvar_num(cvar_iSemiClipRenderFadeMin), 0, SEMI_RENDER_AMOUNT)
	g_iCachedRenderFadeSpec = clamp(get_pcvar_num(cvar_iSemiClipRenderFadeSpec), 0, 1)
	g_iCachedRenderRadius = clamp(get_pcvar_num(cvar_iSemiClipRenderRadius), SEMI_RENDER_AMOUNT - g_iCachedRenderFadeMin, 4095)
}

// credits to MeRcyLeZZ
public do_random_spawn(id)
{
	if (!g_bIsConnected[id] || !g_bIsAlive[id]) return
	
	static hull, sp_index, i
	hull = (pev(id, pev_flags) & FL_DUCKING) ? HULL_HEAD : HULL_HUMAN
	
	switch (g_iTeam[id])
	{
		case 1 : // TERRORIST, ALLIES
		{
			if (!g_iSpawnCount2) return
			
			sp_index = random_num(0, g_iSpawnCount2 - 1)
			for (i = sp_index + 1; /*no condition*/; i++)
			{
				if (i >= g_iSpawnCount2) i = 0
				
				if (is_hull_vacant(g_flSpawns2[i], hull))
				{
					engfunc(EngFunc_SetOrigin, id, g_flSpawns2[i])
					break
				}
				
				if (i == sp_index) break
			}
		}
		case 2 : // CT, AXIS
		{
			if (!g_iSpawnCount) return
			
			sp_index = random_num(0, g_iSpawnCount - 1)
			for (i = sp_index + 1; /*no condition*/; i++)
			{
				if (i >= g_iSpawnCount) i = 0
				
				if (is_hull_vacant(g_flSpawns[i], hull))
				{
					engfunc(EngFunc_SetOrigin, id, g_flSpawns[i])
					break
				}
				
				if (i == sp_index) break
			}
		}
	}
}

public spec_check(taskid)
{
	if (!g_iCachedRenderMode || g_bIsAlive[ID_SPECTATOR]) return
	
	static spec
	spec = pev(ID_SPECTATOR, PEV_SPEC_TARGET)
	
	if (g_bIsAlive[spec])
	{
		g_iSpectating[ID_SPECTATOR] = spec
		g_iSpectatingTeam[ID_SPECTATOR] = g_iTeam[spec]
	}
}

calc_fade(host, ent, mode)
{
	if (mode)
	{
		if (g_iCachedRenderFadeMin > g_iCachedRenderRadius)
			return MAX_RENDER_AMOUNT;
		
		new range = floatround(entity_range(host, ent))
		
		if (range >= g_iCachedRenderRadius)
			return MAX_RENDER_AMOUNT;
		
		new amount
		amount = SEMI_RENDER_AMOUNT - g_iCachedRenderFadeMin
		amount = g_iCachedRenderRadius / amount
		amount = range / amount + g_iCachedRenderFadeMin
		
		return amount;
	}
	else
	{
		new range = floatround(entity_range(host, ent))
		
		if (range < g_iCachedRenderRadius)
			return g_iCachedRenderAmt;
	}
	
	return MAX_RENDER_AMOUNT;
}

set_cvars(id)
{
	g_iTeam[id] = 0
	g_bIsAlive[id] = false
	g_bIsBot[id] = false
	g_bSolid[id] = false
	g_bHaveSemiClip[id] = false
}

/*================================================================================
 [Message Hooks]
=================================================================================*/

/*
	TeamInfo:
	read_data(1)	byte	EventEntity
	read_data(2)	string	TeamName
	
	type |                             name |      calls | time / min / max
	   n |                  get_msg_arg_int |        502 | 0.000500 / 0.000001 / 0.000001
	   n |               get_msg_arg_string |        502 | 0.000519 / 0.000001 / 0.000001
	   p |                 message_TeamInfo |        998 | 0.002234 / 0.000001 / 0.000004
	
	fast enough!
*/
public message_TeamInfo(msg_id, msg_dest)
{
	if (msg_dest != MSG_ALL && msg_dest != MSG_BROADCAST) return
	
	static id, team[2]
	id = get_msg_arg_int(1)
	get_msg_arg_string(2, team, charsmax(team))
	switch (team[0])
	{
		case 'T' : // TERRORIST
		{
			g_iTeam[id] = 1;
		}
		case 'C' : // CT
		{
			g_iTeam[id] = 2;
		}
		case 'S' : // SPECTATOR
		{
			g_iTeam[id] = 3;
		}
		default : g_iTeam[id] = 0;
	}
	
	if (g_bIsAlive[id] && g_iCachedUnstuck && g_iCachedBlockTeams == g_iTeam[id])
	{
		if (!is_player_stuck(id)) return
		
		if (g_flCachedUnstuckDelay > 0.0)
			set_task(g_flCachedUnstuckDelay, "do_random_spawn", id)
		else
			do_random_spawn(id)
	}
}

/*
	PTeam:
	read_data(1)	byte	EventEntity
	read_data(2)	byte	TeamIndex
*/
public message_PTeam(msg_id, msg_dest)
{
	if (msg_dest != MSG_ALL && msg_dest != MSG_BROADCAST) return
	
	static id
	id = get_msg_arg_int(1)
	
	// 0 - UNASSIGNED
	// 1 - ALLIES
	// 2 - AXIS
	// 3 - SPECTATOR
	g_iTeam[id] = get_msg_arg_int(2)
	
	if (g_bIsAlive[id] && g_iCachedUnstuck && g_iCachedBlockTeams == g_iTeam[id])
	{
		if (!is_player_stuck(id)) return
		
		if (g_flCachedUnstuckDelay > 0.0)
			set_task(g_flCachedUnstuckDelay, "do_random_spawn", id)
		else
			do_random_spawn(id)
	}
}

/*================================================================================
 [Stocks]
=================================================================================*/

// credits to VEN
stock is_player_stuck(id)
{
	static Float:originF[3]
	pev(id, pev_origin, originF)
	
	engfunc(EngFunc_TraceHull, originF, originF, 0, (pev(id, pev_flags) & FL_DUCKING) ? HULL_HEAD : HULL_HUMAN, id, 0)
	
	if (get_tr2(0, TR_StartSolid) || get_tr2(0, TR_AllSolid) || !get_tr2(0, TR_InOpen))
		return true
	
	return false
}

// credits to VEN
stock is_hull_vacant(Float:origin[3], hull)
{
	engfunc(EngFunc_TraceHull, origin, origin, 0, hull, 0, 0)
	
	if (!get_tr2(0, TR_StartSolid) && !get_tr2(0, TR_AllSolid) && get_tr2(0, TR_InOpen))
		return true
	
	return false
}

// credits to MeRcyLeZZ
stock collect_spawns_ent(const classname[])
{
	new ent = -1
	while ((ent = engfunc(EngFunc_FindEntityByString, ent, "classname", classname)) != 0)
	{
		new Float:originF[3]
		pev(ent, pev_origin, originF)
		g_flSpawns[g_iSpawnCount][0] = originF[0]
		g_flSpawns[g_iSpawnCount][1] = originF[1]
		g_flSpawns[g_iSpawnCount][2] = originF[2]
		
		g_iSpawnCount++
		if (g_iSpawnCount >= sizeof g_flSpawns) break
	}
}

// credits to MeRcyLeZZ
stock collect_spawns_ent2(const classname[])
{
	new ent = -1
	while ((ent = engfunc(EngFunc_FindEntityByString, ent, "classname", classname)) != 0)
	{
		new Float:originF[3]
		pev(ent, pev_origin, originF)
		g_flSpawns2[g_iSpawnCount2][0] = originF[0]
		g_flSpawns2[g_iSpawnCount2][1] = originF[1]
		g_flSpawns2[g_iSpawnCount2][2] = originF[2]
		
		g_iSpawnCount2++
		if (g_iSpawnCount2 >= sizeof g_flSpawns2) break
	}
}

stock load_spawns()
{
	if (g_iMod == MOD_CSTRIKE)
	{
		collect_spawns_ent("info_player_start")
		collect_spawns_ent2("info_player_deathmatch")
	}
	else if (g_iMod == MOD_DOD)
	{
		collect_spawns_ent("info_player_axis")
		collect_spawns_ent2("info_player_allies")
	}
	else
	{
		set_pcvar_num(cvar_iSemiClipUnstuck, 0)
	}
}

// amxmisc.inc
stock get_configsdir(name[], len)
{
	return get_localinfo("amxx_configsdir", name, len);
}
