// Should the plugin save player data in SQL database?
// To save player data in a vault, change "#define USING_SQL" to "//#define USING_SQL"
// To save player data in SQL, change "//#define USING_SQL" to "#define USING_SQL"
// If you comment //#define USING_REGEX its a little bit more non-steam friendly 

//#define USING_SQL
#define USING_REGEX

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <engine>
#include <fakemeta>
#include <hamsandwich>
#include <nvault>
#include <csx>
#include <fun>
#include <xs>

#if defined USING_REGEX
#include <regex>
#endif

#if defined USING_SQL
#include <sqlx>

new Handle:g_sql_tuple
#else
#include <nvault>

new g_iVault
#endif

#if defined USING_SQL
new g_loaded_data[ 33 ]
#endif

#define VERSION "1.9"

#define XO_PLAYER            5
#define m_pPlayer	     41
#define m_fInReload          54
#define m_fInSpecialReload   55
#define m_flTimeWeaponIdle   48
#define m_flFlashedUntil     514
#define m_flFlashedAt        515
#define m_flFlashHoldTime    516
#define m_flFlashDuration    517
#define m_iFlashAlpha        518
#define ALPHA_FULLBLINDED    255

#define INTERVAL 60

new g_iMaxPlayers
#define IsPlayer(%1) (1 <= %1 <= g_iMaxPlayers)

const MAX_PLAYERS = 32
const MAX_WEAPONS = CSW_P90

new g_iMsgId_SayText, g_iBombTime,
	g_iPlanter, g_iGetBombPlanted
	
new const g_szAchievementSound[] = "achievement.wav"

new const Float:vecNullOrigin[ 3 ]

new Float:flDistance[ MAX_PLAYERS + 1 ],
	Float:vecOldOrigin[ MAX_PLAYERS + 1 ][ 3 ],
	Float:g_iFeet = 35.0
	
new g_iRounds, g_fwid
new g_iTeamKills[ 33 ], g_iRoundSparys[ 33 ], 
	g_iKills[ 33 ], g_iShotKills[ 33 ],
	g_iGrenadeKills[ 33 ]
new bool:g_iBombPlant, bool:g_bFeet, bool:is_dead[ 33 ],
	bool:StandAlone[ 33 ], bool:OneHpHero[ 33 ],
	bool:is_VictimInAir[ 33 ], bool:iKillerHasNotMoved[ 33 ],
	bool:iKillerShot[ 33 ], bool:is_Connected[ 33 ],
	bool:is_Alive[ 33 ], bool:is_DefusingWithKit,
	bool:g_iGetBombDown, bool:g_iDeathMessages[ 33 ]  

new g_iHelpMotd[ 43 ]

#if defined USING_REGEX
new Regex:g_SteamID_pattern
new g_regex_return
#endif
	
enum _:g_iAchCount
{
	CONNECTIONS,
	HEAD_SHOTS,
	DISTANCE_KILLED,
	DISTANCE_WALKED,
	BOMB,
	PLANT_BOMB,
	PLANT_BOMB_COUNT,
	DEFUSED_BOMB,
	TOTAL_KILLS,
	PISTOL_MASTER,
	RIFLE_MASTER,
	SHOTGUN_MASTER,
	SPRAY_N_PRAY,
	MASTER_AT_ARMS,
	PLAY_AROUND,
	STAND_ALONE,
	ONE_HP_HERO,
	BAD_FRIEND,
	URBAN_DESIGNER,
	GRAFFITI,
	AMMO_CONSERVATION,
	FLY_AWAY,
	RELOADER,
	CAMP_FIRE,
	HAT_TRICK,
	COWBOY_DIPLOMACY
}

new const g_iAchsMotd[g_iAchCount][] =
{
	"Ultimate Server Lover",
	"Boom Head-Shot",
	"Distance Killed",
	"Distance Walked",
	"OMFG that was close",
	"Short Fuse",
	"Boomala Boomala",
	"Nothing Can Blow Up",
	"God of War",
	"Pistol Master",
	"Rifle Master",
	"Shotgun Master",
	"Spray and Pray",
	"Master At Arms",
	"Play Around",
	"Stand Alone",
	"1 Hp Hero",
	"Bad Friend",
	"Urban Designer",
	"Graffiti Is My Second Name",
	"Ammo Conservation",
	"Fly Away",
	"Reloader",
	"Camp Fire",
	"Hat Trick",
	"Cowboy Diplomacy"
}

new const g_iAchsMaxPoints[g_iAchCount] =
{
	1000, 	// Connections
	300,	// Headshots
	4,	// distance killed
	3,	// distance walk
	1,	// bomb
	1,	// Plant bomb
	100,	// plant bomb count
	400,	// Defused Bomb
	10000,	// total kills
	6,	// Pistol master
	10,	// rifle Master
	2,	// shotgun master
	1,	// spray and pray
	25,	// Master of Arms
	60, 	// Play Around
	15,	// Stand Alone
	1,	// 1 Hp Hero
	5,	// Bad Friend
	300,	// Urban Designer
	1,	// Graffiti Is My Second Name
	1,	// Ammo Conservation
	1,	// Fly way
	1000,	// Reloader
	1,	// Camp Fire
	1,	// HatTrick
	100	// Cowboy Diplomacy
}

new g_iAuthID[ 33 ][ 36 ]

//Cvars
new g_pCvar_Enabled, g_pCvarC4Timer,
	g_pCvar_ShowInfo, g_pCvar_DeathMessage,
	g_pCvar_FlashMessage, g_pCvar_BombMessage
	//g_pCvar_FriendlyFire

new const g_szWeaponNames[][] =
{
	"p228",
	"scout",              
	"hegrenade",              
	"xm1014",
	"c4",                    
	"mac10",             
	"aug", 
	"smokegrenade",            
	"elite",          
	"fiveseven",
	"ump45",               
	"sg550",
	"galil",  
	"famas",
	"usp",   
	"glock18",   
	"awp",  
	"mp5navy",     
	"m249",            
	"m3",  
	"m4a1",                
	"tmp",      
	"g3sg1",    
	"flashbang",            
	"deagle",
	"sg552", 
	"ak47",      
	"knife",                   
	"p90"
}

#define WEAPON_SIZE sizeof(g_szWeaponNames)

new const g_iWeaponIDs[WEAPON_SIZE] =
{
	CSW_P228,
	CSW_SCOUT,
	CSW_HEGRENADE,
	CSW_XM1014,
	CSW_C4,
	CSW_MAC10,
	CSW_AUG,
	CSW_SMOKEGRENADE,
	CSW_ELITE,
	CSW_FIVESEVEN,
	CSW_UMP45,
	CSW_SG550,
	CSW_GALIL,
	CSW_FAMAS,
	CSW_USP,
	CSW_GLOCK18,
	CSW_AWP,
	CSW_MP5NAVY,
	CSW_M249,
	CSW_M3,
	CSW_M4A1,
	CSW_TMP,
	CSW_G3SG1,
	CSW_FLASHBANG,
	CSW_DEAGLE,
	CSW_SG552,
	CSW_AK47,
	CSW_KNIFE,
	CSW_P90
}

new const g_iAchsWeaponMaxKills[] =
{
	200, 	//"p228",           
	1000, 	//"scout",              
	300,  	//"hegrenade",              
	200,	//"xm1014",
	30,	//"c4",                    
	500,	//"mac10",             
	500, 	//"aug", 
	150,	//"smokegrenade",            
	100, 	//"elite",          
	100,	//"fiveseven",
	1000,	//"ump45",               
	500,	//"sg550",
	500,	//"galil",  
	500,	//"famas",
	200,	//"usp",   
	200,	//"glock18",   
	1000,	//"awp",  
	1000,	//"mp5navy",     
	500,	//"m249",            
	200,	//"m3",  
	1000,	//"m4a1",                
	1000,	//"tmp",      
	500,	//"g3sg1",    
	150,	//"flashbang",            
	200,	//"deagle",
	500,	//"sg552", 
	1000,	//"ak47",      
	200,	//"knife",                   
	1000	//"p90" 
}

new const g_szWeaponNames2[WEAPON_SIZE][] =
{
	"P228",
	"Scout",              
	"He-Grenade",              
	"XM1014",
	"C4",                    
	"Mac10",             
	"Aug", 
	"Smoke-Grenade",            
	"Elite",          
	"Fiveseven",
	"Ump45",               
	"SG550",
	"Galil",  
	"Famas",
	"USP",   
	"Glock",   
	"AWP",  
	"MP5",     
	"M249",            
	"M3",  
	"M4A1",                
	"TMP",      
	"G3SG1",    
	"FlashBang",            
	"Deagle",
	"SG552", 
	"AK47",      
	"Knife",                   
	"P90"
}

new const g_iGunEvents[][] = {
	"events/awp.sc",
	"events/g3sg1.sc",
	"events/ak47.sc",
	"events/scout.sc",
	"events/m249.sc",
	"events/m4a1.sc",
	"events/sg552.sc",
	"events/aug.sc",
	"events/sg550.sc",
	"events/m3.sc",
	"events/xm1014.sc",
	"events/usp.sc",
	"events/mac10.sc",
	"events/ump45.sc",
	"events/fiveseven.sc",
	"events/p90.sc",
	"events/deagle.sc",
	"events/p228.sc",
	"events/glock18.sc",
	"events/mp5n.sc",
	"events/tmp.sc",
	"events/elite_left.sc",
	"events/elite_right.sc",
	"events/galil.sc",
	"events/famas.sc"
}

new g_iPlayersKills[ MAX_PLAYERS+1 ][ MAX_WEAPONS+1 ]
new g_iAchLevel[ MAX_PLAYERS+1 ][ g_iAchCount ]
new g_iTimerEntity, g_iJoinTime[ MAX_PLAYERS ]

new Trie:g_tWeaponNameToID
new iWeaponID, g_iGunEvent_IDsBitsum

public plugin_init() {
	
	#if defined USING_SQL
	register_plugin( "Achievements (SQL)", VERSION, "!Pastout!!" )
	#else
	register_plugin( "Achievements", VERSION, "!Pastout!!" )
	#endif

	g_pCvar_Enabled = register_cvar("ach_enable", "1")// 1 = on || 0 = off
	if ( !get_pcvar_num( g_pCvar_Enabled ) )
		return;
	
	g_pCvarC4Timer = get_cvar_pointer( "mp_c4timer" )
	g_pCvar_ShowInfo = register_cvar( "ach_showinfo", "1" )
	g_pCvar_DeathMessage = register_cvar( "ach_deathmessage", "1" )
	g_pCvar_FlashMessage = register_cvar( "ach_flashmessage", "1" )
	g_pCvar_BombMessage = register_cvar( "ach_bombmessage", "1" )
	//g_pCvar_FriendlyFire = get_cvar_pointer( "mp_friendlyfire" )
	
	new command[] = "CmdMainMenu"
	register_clcmd( "say /achievement", command )
	register_clcmd( "say /achievements", command )
	register_clcmd( "say /ach", command )
	register_clcmd( "say /help", "Ach_HelpMenu" )
	register_clcmd( "say /deathmessage", "CmdDeathMessage" )
	
	register_event( "DeathMsg", "Event_PlayerKilled", "a" )
	register_event( "HLTV", "Event_NewRound", "a", "1=0", "2=0" )
	register_event( "StatusIcon", "Event_GotBomb", "be", "1=1", "1=2", "2=c4" )
	register_event( "ResetHUD", "Event_ResetHud", "be" )
	register_event( "23", "Event_Spray", "a", "1=112" )
	
	register_logevent( "Event_PlayerAction", 3, "1=triggered" )
	
	g_iTimerEntity = create_entity( "info_target" )
	entity_set_string( g_iTimerEntity, EV_SZ_classname, "hud_entity" )
	register_think( "hud_entity", "fw_HUDThink" )
	entity_set_float( g_iTimerEntity, EV_FL_nextthink, get_gametime() + 1.0 )
	
	g_iMaxPlayers = get_maxplayers()
	g_iMsgId_SayText = get_user_msgid( "SayText" )
	g_tWeaponNameToID = TrieCreate()
	
	for( new i = 0; i < WEAPON_SIZE; i++ )
	{
		TrieSetCell( g_tWeaponNameToID, g_szWeaponNames[i], g_iWeaponIDs[i] )
	}
	
	new const NO_RELOAD = ( 1 << 2 ) | ( 1 << CSW_KNIFE ) | ( 1 << CSW_C4 ) | ( 1 << CSW_M3 ) |
		( 1 << CSW_XM1014 ) | ( 1 << CSW_HEGRENADE ) | ( 1 << CSW_FLASHBANG ) | ( 1 << CSW_SMOKEGRENADE )
    
	new szWeaponName[ 20 ]
	for( new i = CSW_P228; i <= CSW_P90; i++ ) {
		if( NO_RELOAD & ( 1 << i ) )
			continue;
			
		get_weaponname( i, szWeaponName, 19 )
		RegisterHam( Ham_Weapon_Reload, szWeaponName, "FwdHamWeaponReload", 1 )
	}
	
	RegisterHam( Ham_Weapon_Reload, "weapon_m3",     "FwdHamShotgunReload", 1 )
	RegisterHam( Ham_Weapon_Reload, "weapon_xm1014", "FwdHamShotgunReload", 1 )
	RegisterHam( Ham_TraceAttack, "player", "FwdHamTraceAttack" )
	RegisterHam( Ham_Spawn, "player", "FwdPlayerSpawn", 1 )
	
	unregister_forward( FM_PrecacheEvent, g_fwid, 1 )
	register_forward( FM_PlaybackEvent, "FwdPlaybackEvent" )
	register_forward( FM_CmdStart, "FwdCmdStart" )

	new dir[ 23 ]
	get_configsdir( dir, 22 )
	formatex( g_iHelpMotd, 42, "%s/achievements.txt", dir )
	
	#if !defined USING_SQL
	g_iVault = nvault_open("Achievements")
    
	if(g_iVault == INVALID_HANDLE)
		set_fail_state( "Error opening nVault" )
	
	#endif
	
	#if defined USING_REGEX
	new err[ 2 ]
	g_SteamID_pattern = regex_compile( "^^STEAM_0:(0|1):\d+$", g_regex_return, err, sizeof( err ) - 1 )
	#endif
}

public Event_PlayerAction( )
{
	new szArg[ 64 ], szAction[ 64 ], szName[ 64 ]
	new iUserId, id
	
	read_logargv( 0, szArg, 64 )
	read_logargv( 2, szAction, 64 )
	parse_loguser( szArg, szName, 64, iUserId )
	id = find_player( "k", iUserId )
	
	if( id == 0 )
	{
		return
	}
	#if defined USING_REGEX
	if( !IsUserAuthorized( id ) )
	{
		return
	}
	#endif
	if( equal( szAction, "Rescued_A_Hostage" ) )
	{
		g_iAchLevel[ id ][ COWBOY_DIPLOMACY ]++
		switch( g_iAchLevel[ id ][ COWBOY_DIPLOMACY ] )
		{
			case 100:
			{
				g_iAchLevel[ id ][ COWBOY_DIPLOMACY ]++
				Print( 0, "%s^1 has earned ^3'^1Cowboy Diplomacy^3'^4 achievement!", szName ) 
				emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
		Print( 0, "%s^1 has^4 rescued^1 a^3 Hostage^1.", szName )// Hostage rescued 
	}
	
	if( get_pcvar_num( g_pCvar_BombMessage ) == 1 )
	{
		if( equal( szAction, "Begin_Bomb_Defuse_With_Kit" ) )
		{
			is_DefusingWithKit = true
		}
	}
	#if defined USING_REGEX
	return
	#endif
}

public FwdHamWeaponReload( const iWeapon ) {
	
	new iPlayers[ 32 ], iNum, iPlayer
	get_players(iPlayers, iNum, "ah")
	for( new i = 0; i < iNum; i++ ) 
	{
		 iPlayer = iPlayers[ i ]
	}
	
	#if defined USING_REGEX
	if( !IsUserAuthorized( iPlayer ) )
	{
		return
	}
	#endif
	
	new szName[ 32 ]
	get_user_name( iPlayer, szName, charsmax( szName ) )
	
	if( get_pdata_int( iWeapon, m_fInReload, 4 ) ) {
		g_iAchLevel[ iPlayer ][ RELOADER ]++
		switch( g_iAchLevel[ iPlayer ][ RELOADER ] )
		{
			case 1000:
			{
				g_iAchLevel[ iPlayer ][ RELOADER ]++
				Print( 0, "%s^1 has earned ^3'^1Reloader^3'^4 achievement!", szName ) 
				emit_sound( iPlayer, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}
	#if defined USING_REGEX
	return
	#endif
}

public FwdHamShotgunReload( const iWeapon ) {
	if( get_pdata_int( iWeapon, m_fInSpecialReload, 4 ) != 1 )
		return
	new Float:flTimeWeaponIdle = get_pdata_float( iWeapon, m_flTimeWeaponIdle, 4 )
    
	if( flTimeWeaponIdle != 0.55 )
		return
	
	new iPlayers[ 32 ], iNum, iPlayer
	get_players(iPlayers, iNum, "ah")
	for( new i = 0; i < iNum; i++ ) 
	{
		 iPlayer = iPlayers[ i ]
	}
	
	#if defined USING_REGEX
	if( !IsUserAuthorized( iPlayer ) )
	{
		return
	}
	#endif
	
	new szName[ 32 ]
	get_user_name( iPlayer, szName, charsmax( szName ) )
	
	g_iAchLevel[ iPlayer ][ RELOADER ]++
	switch( g_iAchLevel[ iPlayer ][ RELOADER ] )
	{
		case 1000:
		{
			g_iAchLevel[ iPlayer ][ RELOADER ]++
			Print( 0, "%s^1 has earned ^3'^1Reloader^3'^4 achievement!", szName ) 
			emit_sound( iPlayer, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
	}
	#if defined USING_REGEX
	return
	#endif
}

public fw_HUDThink( iEntity )
{
	if ( iEntity != g_iTimerEntity )
		return
		
	static id
	new szName[ 32 ]
	for ( id = 1; id <= MAX_PLAYERS; id++ )
	{
		if ( is_user_connected( id ) && ( ( get_systime() - g_iJoinTime[ id ] ) >= INTERVAL ) )
		{
			#if defined USING_REGEX
			if( !IsUserAuthorized( id ) )
			{
				return
			}
			#endif
			get_user_name( id, szName, charsmax( szName ) )
			g_iJoinTime[ id ] = get_systime()
			g_iAchLevel[ id ][ PLAY_AROUND ]++
			switch( g_iAchLevel[ id ][ PLAY_AROUND ] )
			{
				case 60:
				{
					g_iAchLevel[ id ][ PLAY_AROUND ]++
					Print( 0, "%s^1 has earned ^3'^1Play Around^3'^4 achievement!", szName ) 
					emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
			#if defined USING_REGEX
			return
			#endif
		}
	}
    
	entity_set_float( g_iTimerEntity, EV_FL_nextthink, get_gametime() + 1.0 )
}  

public CmdDeathMessage( id )
{
	if( get_pcvar_num( g_pCvar_DeathMessage ) != 1 )
	{
		Print( id, "^3Sorry^1 the^4 death message^1 have been^4 disable^1 for^3 everyone." )
		return PLUGIN_HANDLED
	}
	if( g_iDeathMessages[ id ] == false )
	{
		g_iDeathMessages[ id ] = true
		Print( id, "^1You have^4 Enable^3 death messages^1." )
	} 
	else 
	{
		if( g_iDeathMessages[ id ] == true )
		{
			g_iDeathMessages[ id ] = false
			Print( id, "^1You have^4 Disable^3 death messages^1." )
		}
	}
	return PLUGIN_HANDLED
}

public plugin_precache()
{
	g_fwid = register_forward( FM_PrecacheEvent, "FwdPrecacheEvent", 1 )
	precache_sound( g_szAchievementSound )
	
	#if defined USING_SQL
	g_sql_tuple = SQL_MakeStdTuple()
	
	SQL_ThreadQuery(g_sql_tuple, "QueryCreateTable", "CREATE TABLE IF NOT EXISTS ^"Achievement^" ( ^"name^" VARCHAR(32) NOT NULL, ^"authid^" VARCHAR(35) NOT NULL, ^"data^" VARCHAR(256) NOT NULL );" )
	
	#endif
}

public FwdPrecacheEvent( type, const name[] ) {
	for( new i = 0; i < sizeof g_iGunEvents; ++i ) {
		if( equal( g_iGunEvents[ i ], name ) ) {
			g_iGunEvent_IDsBitsum |= ( 1<<get_orig_retval() )
			return FMRES_HANDLED
		}
	}
	return FMRES_IGNORED
}

public FwdPlaybackEvent( flags, id, eventid ) {
	if( !( g_iGunEvent_IDsBitsum & ( 1<<eventid) ) || !(1 <= id <= g_iMaxPlayers ) )
		return FMRES_IGNORED
		
	iKillerShot[ id ] = false
	g_iShotKills[ id ] = 0

	return FMRES_HANDLED
}

public FwdHamTraceAttack( this, iAttacker, Float:damage, Float:direction[ 3 ], traceresult, damagebits )
{
	if( is_Connected[ iAttacker ] && is_Alive[ iAttacker ] )
	{
		static g_iWeapon; g_iWeapon = get_user_weapon( iAttacker )
		if( g_iWeapon == CSW_KNIFE || g_iWeapon == CSW_HEGRENADE )
		{
			return PLUGIN_HANDLED
		}
		
		iKillerShot[ iAttacker ] = true
	
	}
	return PLUGIN_HANDLED
	
}

#if defined USING_SQL
public QueryCreateTable(failstate, Handle:query, error[], errnum, data[], size, Float:queuetime)
{
	if( failstate == TQUERY_CONNECT_FAILED
	|| failstate == TQUERY_QUERY_FAILED )
	{
		set_fail_state(error)
	}
}
#endif

public Ach_HelpMenu( id )
{
	show_motd( id, g_iHelpMotd, "Achievements Help" )
	Print( id, "^1This server is using^3 Achievements^4 v%s^1, by^3 Pastout!", VERSION )	
}

public CmdMainMenu( id )
{
	Ach_StartMenu( id )
}

public Ach_StartMenu( id ) {
	//Menu Title
	new title[ 256 ]; formatex( title, sizeof( title ) - 1, "\yMain Menu^n" )
	//Create the menu
	new menu = menu_create( title, "StartMenu_Handle" )
	menu_additem( menu, "\wInfo", "1", 0 )
	menu_additem( menu, "\wWeapon\y Achievements\r Player Info", "2", 0 )
	menu_additem( menu, "\wCustom\y Achievements\r Player Info", "3", 0 )
	menu_additem( menu, "\wHelp", "4", 0 )
	menu_display( id, menu )
}

public StartMenu_Handle( id, menu, item )
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu )
		return PLUGIN_HANDLED
	}
	
	new data[ 6 ], iName[ 64 ]
	new access, callback
	
	menu_item_getinfo( menu, item, access, data, 5, iName, 63, callback )
	
	new key = str_to_num( data )
	switch( key )
	{
		case 1:
		{
			Print( id, "^1This server is using^3 Achievements^4 v%s^1, by^3 Pastout!", VERSION )
			Ach_StartMenu( id )
		}
		case 2:
		{
			Ach_WeaponStartMenu( id )
		}
		case 3:
		{
			Ach_PlayerStartMenu( id )
		}
		case 4:
		{
			Ach_HelpMenu( id )
			Ach_StartMenu( id )
		}
	}
	return PLUGIN_HANDLED
}

public Ach_WeaponStartMenu( id ) {
	new title[ 256 ]; formatex( title, sizeof( title ) - 1, "\rWeapon\w Achievements^n" )
	new menu = menu_create( title, "WeaponStartMenu_Handle" )
	menu_additem( menu, "\yAchievements\r 1/10", "1", 0 )
	menu_additem( menu, "\yAchievements\r 11/20", "2", 0 )
	menu_additem( menu, "\yAchievements\r 21/29", "3", 0 )
	menu_additem( menu, "\wHelp", "4", 0 )
	menu_display( id, menu )
}

public WeaponStartMenu_Handle( id, menu, item )
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu )
		return PLUGIN_HANDLED
	}
	
	new data[ 6 ], iName[ 64 ]
	new access, callback
	
	menu_item_getinfo( menu, item, access, data, 5, iName, 63, callback )
	
	new key = str_to_num( data )
	switch( key )
	{
		case 1:
		{
			Ach_PlayerWeaponMenu( id )
		}
		case 2:
		{
			Ach_PlayerWeaponMenu2( id )
		}
		case 3:
		{
			Ach_PlayerWeaponMenu3( id )
		}
		case 4:
		{
			Ach_HelpMenu( id )
			Ach_StartMenu( id )
		}
	}
	return PLUGIN_HANDLED
}

public Ach_PlayerWeaponMenu( id )
{
	new title[ 170 ]; formatex( title, sizeof( title ) - 1, "\rWeapon Achievements^n\w - \yPlayer Menu")
	new menu = menu_create( title, "Ach_PlayerWeaponMenu_Handle" )
	
	new players[ 32 ], pnum, tempid
	new szName[ 32 ], szTempid[ 10 ]
	
	get_players( players, pnum )
	
	for( new i; i < pnum; i++ )
	{
		tempid = players[ i ]
		
		get_user_name( tempid, szName, 31 )
		num_to_str( tempid, szTempid, 9 )
		
		menu_additem( menu, szName, szTempid, 0 )
	}
	
	menu_display( id, menu )
}

public Ach_PlayerWeaponMenu_Handle( id, menu, item )
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu )
		if( is_Connected[ id ] )
			Ach_WeaponStartMenu( id )
		return PLUGIN_HANDLED
	}
	
	new data[ 6 ], iName[ 64 ]
	new access, callback
	menu_item_getinfo( menu, item, access, data, 5, iName, 63, callback )
	
	new tempid = str_to_num( data )
	new tempname[ 32 ]; get_user_name( tempid, tempname, 31 )
	
	static motd[ 2500 ], len
	len = format( motd, sizeof( motd ) - 1,			"<body bgcolor=#10497d>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<table width=100%% cellpadding=2 cellspacing=4 border=4>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#52697B>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=10%% align=left>%s", tempname )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=15%% align=center>Achievement Level" );
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=20%% align=center>Achievement Max Level" )

	for( new i = 0; i < 10; i++ )
	{
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#c7c7c7>" )
		len += format( motd[ len ], sizeof( motd ) - len - 1,	"<td align=left>%s", g_szWeaponNames2[ i ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iPlayersKills[ tempid ][ g_iWeaponIDs[ i ] ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iAchsWeaponMaxKills[ i ] )
	}
	len += format( motd[ len ], sizeof( motd ) - len - 1,	"</table></body>" )
	
	show_motd( id, motd, "Player Info" )
	menu_display( id, menu )
	menu_destroy( menu )
	return PLUGIN_HANDLED
}

public Ach_PlayerWeaponMenu2( id )
{
	new title[ 170 ]; formatex( title, sizeof( title ) - 1, "\rWeapon Achievements^n\w - \yPlayer Menu")
	new menu = menu_create( title, "Ach_PlayerWeaponMenu2_Handle" )
	
	new players[ 32 ], pnum, tempid
	new szName[ 32 ], szTempid[ 10 ]
	
	get_players( players, pnum )
	
	for( new i; i < pnum; i++ )
	{
		tempid = players[ i ]
		
		get_user_name( tempid, szName, 31 )
		num_to_str( tempid, szTempid, 9 )
		
		menu_additem( menu, szName, szTempid, 0 )
	}
	
	menu_display( id, menu )
}

public Ach_PlayerWeaponMenu2_Handle( id, menu, item )
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu )
		if( is_Connected[ id ] )
			Ach_WeaponStartMenu( id )
		return PLUGIN_HANDLED
	}
	
	new data[ 6 ], iName[ 64 ]
	new access, callback
	menu_item_getinfo( menu, item, access, data, 5, iName, 63, callback )
	
	new tempid = str_to_num( data )
	new tempname[ 32 ]; get_user_name( tempid, tempname, 31 )
	
	static motd[ 2500 ], len
	len = format( motd, sizeof( motd ) - 1,			"<body bgcolor=#10497d>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<table width=100%% cellpadding=2 cellspacing=4 border=4>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#52697B>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=10%% align=left>%s", tempname )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=15%% align=center>Achievement Level" );
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=20%% align=center>Achievement Max Level" )

	for( new i = 10; i < 20; i++ )
	{
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#c7c7c7>" )
		len += format( motd[ len ], sizeof( motd ) - len - 1,	"<td align=left>%s", g_szWeaponNames2[ i ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iPlayersKills[ tempid ][ g_iWeaponIDs[ i ] ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iAchsWeaponMaxKills[ i ] )
	}
	len += format( motd[ len ], sizeof( motd ) - len - 1,	"</table></body>" )
	
	show_motd( id, motd, "Player Info" )
	menu_display( id, menu )
	menu_destroy( menu )
	return PLUGIN_HANDLED
}

public Ach_PlayerWeaponMenu3( id )
{
	new title[ 170 ]; formatex( title, sizeof( title ) - 1, "\rWeapon Achievements^n\w - \yPlayer Menu")
	new menu = menu_create( title, "Ach_PlayerWeaponMenu3_Handle" )
	
	new players[ 32 ], pnum, tempid
	new szName[ 32 ], szTempid[ 10 ]
	
	get_players( players, pnum )
	
	for( new i; i < pnum; i++ )
	{
		tempid = players[ i ]
		
		get_user_name( tempid, szName, 31 )
		num_to_str( tempid, szTempid, 9 )
		
		menu_additem( menu, szName, szTempid, 0 )
	}
	
	menu_display( id, menu )
}

public Ach_PlayerWeaponMenu3_Handle( id, menu, item )
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu )
		if( is_Connected[ id ] )
			Ach_WeaponStartMenu( id )
		return PLUGIN_HANDLED
	}
	
	new data[ 6 ], iName[ 64 ]
	new access, callback
	menu_item_getinfo( menu, item, access, data, 5, iName, 63, callback )
	
	new tempid = str_to_num( data )
	new tempname[ 32 ]; get_user_name( tempid, tempname, 31 )
	
	static motd[ 2500 ], len
	len = format( motd, sizeof( motd ) - 1,			"<body bgcolor=#10497d>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<table width=100%% cellpadding=2 cellspacing=4 border=4>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#52697B>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=10%% align=left>%s", tempname )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=15%% align=center>Achievement Level" );
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=20%% align=center>Achievement Max Level" )

	for( new i = 20; i < WEAPON_SIZE; i++ )
	{
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#c7c7c7>" )
		len += format( motd[ len ], sizeof( motd ) - len - 1,	"<td align=left>%s", g_szWeaponNames2[ i ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iPlayersKills[ tempid ][ g_iWeaponIDs[ i ] ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iAchsWeaponMaxKills[ i ] )
	}
	len += format( motd[ len ], sizeof( motd ) - len - 1,	"</table></body>" )
	
	show_motd( id, motd, "Player Info" )
	menu_display( id, menu )
	menu_destroy( menu )
	return PLUGIN_HANDLED
}

public Ach_PlayerStartMenu( id ) {
	new title[ 256 ]; formatex( title, sizeof( title ) - 1, "\rCustom\w Achievements^n" )
	new menu = menu_create( title, "PlayerStartMenu_Handle" )
	menu_additem( menu, "\yAchievements\r 1/10", "1", 0 )
	menu_additem( menu, "\yAchievements\r 11/20", "2", 0 )
	menu_additem( menu, "\yAchievements\r 21/26", "3", 0 )
	menu_additem( menu, "\wHelp", "4", 0 )
	menu_display( id, menu )
}

public PlayerStartMenu_Handle( id, menu, item )
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu )
		return PLUGIN_HANDLED
	}
	
	new data[ 6 ], iName[ 64 ]
	new access, callback
	
	menu_item_getinfo( menu, item, access, data, 5, iName, 63, callback )
	
	new key = str_to_num( data )
	switch( key )
	{
		case 1:
		{
			Ach_PlayerLevelMenu( id )
		}
		case 2:
		{
			Ach_PlayerLevelMenu2( id )
		}
		case 3:
		{
			Ach_PlayerLevelMenu3( id )
		}
		case 4:
		{
			Ach_HelpMenu( id )
			Ach_StartMenu( id )
		}
	}
	return PLUGIN_HANDLED
}

public Ach_PlayerLevelMenu( id )
{
	new title[ 170 ]; formatex( title, sizeof( title ) - 1, "\rCustom Achievements^n\w - \yPlayer Menu")
	new menu = menu_create( title, "Ach_PlayerLevelMenu_Handle" )
	
	new players[ 32 ], pnum, tempid
	new szName[ 32 ], szTempid[ 10 ]
	
	get_players( players, pnum )
	
	for( new i; i < pnum; i++ )
	{
		tempid = players[ i ]
		
		get_user_name( tempid, szName, 31 )
		num_to_str( tempid, szTempid, 9 )
		
		menu_additem( menu, szName, szTempid, 0 )
	}
	
	menu_display( id, menu )
}

public Ach_PlayerLevelMenu_Handle( id, menu, item )
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu )
		if( is_Connected[ id ] )
			Ach_PlayerStartMenu( id )
		return PLUGIN_HANDLED
	}
	
	new data[ 6 ], iName[ 64 ]
	new access, callback
	menu_item_getinfo( menu, item, access, data, 5, iName, 63, callback )
	
	new tempid = str_to_num( data )
	new tempname[ 32 ]; get_user_name( tempid, tempname, 31 )
	
	static motd[ 2500 ], len
	len = format( motd, sizeof( motd ) - 1,			"<body bgcolor=#10497d>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<table width=100%% cellpadding=2 cellspacing=4 border=4>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#52697B>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=10%% align=left>%s", tempname )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=15%% align=center>Achievement Level" );
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=20%% align=center>Achievement Max Level" )
	
	for( new iLevel = 0; iLevel < 10; iLevel++ )
	{
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#c7c7c7>" )
		len += format( motd[ len ], sizeof( motd ) - len - 1,	"<td align=left>%s", g_iAchsMotd[ iLevel ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iAchLevel[ tempid ][ iLevel ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iAchsMaxPoints[ iLevel ] )

	}
	len += format( motd[ len ], sizeof( motd ) - len - 1,	"</table></body>" )
	
	show_motd( id, motd, "Player Info" )
	menu_display( id, menu )
	menu_destroy( menu )
	return PLUGIN_HANDLED
}

public Ach_PlayerLevelMenu2( id )
{
	new title[ 170 ]; formatex( title, sizeof( title ) - 1, "\rCustom Achievements^n\w - \yPlayer Menu")
	new menu = menu_create( title, "Ach_PlayerLevelMenu2_Handle" )
	
	new players[ 32 ], pnum, tempid
	new szName[ 32 ], szTempid[ 10 ]
	
	get_players( players, pnum )
	
	for( new i; i < pnum; i++ )
	{
		tempid = players[ i ]
		
		get_user_name( tempid, szName, 31 )
		num_to_str( tempid, szTempid, 9 )
		
		menu_additem( menu, szName, szTempid, 0 )
	}
	
	menu_display( id, menu )
}

public Ach_PlayerLevelMenu2_Handle( id, menu, item )
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu )
		if( is_Connected[ id ] )
			Ach_PlayerStartMenu( id )
		return PLUGIN_HANDLED
	}
	
	new data[ 6 ], iName[ 64 ]
	new access, callback
	menu_item_getinfo( menu, item, access, data, 5, iName, 63, callback )
	
	new tempid = str_to_num( data )
	new tempname[ 32 ]; get_user_name( tempid, tempname, 31 )
	
	static motd[ 2500 ], len
	len = format( motd, sizeof( motd ) - 1,			"<body bgcolor=#10497d>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<table width=100%% cellpadding=2 cellspacing=4 border=4>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#52697B>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=10%% align=left>%s", tempname )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=15%% align=center>Achievement Level" );
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=20%% align=center>Achievement Max Level" )
	
	for( new iLevel = 10; iLevel < 20; iLevel++ )
	{
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#c7c7c7>" )
		len += format( motd[ len ], sizeof( motd ) - len - 1,	"<td align=left>%s", g_iAchsMotd[ iLevel ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iAchLevel[ tempid ][ iLevel ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iAchsMaxPoints[ iLevel ] )

	}
	len += format( motd[ len ], sizeof( motd ) - len - 1,	"</table></body>" )
	
	show_motd( id, motd, "Player Info" )
	menu_display( id, menu )
	menu_destroy( menu )
	return PLUGIN_HANDLED
}

public Ach_PlayerLevelMenu3( id )
{
	new title[ 170 ]; formatex( title, sizeof( title ) - 1, "\rCustom Achievements^n\w - \yPlayer Menu")
	new menu = menu_create( title, "Ach_PlayerLevelMenu3_Handle" )
	
	new players[ 32 ], pnum, tempid
	new szName[ 32 ], szTempid[ 10 ]
	
	get_players( players, pnum )
	
	for( new i; i < pnum; i++ )
	{
		tempid = players[ i ]
		
		get_user_name( tempid, szName, 31 )
		num_to_str( tempid, szTempid, 9 )
		
		menu_additem( menu, szName, szTempid, 0 )
	}
	
	menu_display( id, menu )
}

public Ach_PlayerLevelMenu3_Handle( id, menu, item )
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu )
		if( is_Connected[ id ] )
			Ach_PlayerStartMenu( id )
		return PLUGIN_HANDLED
	}
	
	new data[ 6 ], iName[ 64 ]
	new access, callback
	menu_item_getinfo( menu, item, access, data, 5, iName, 63, callback )
	
	new tempid = str_to_num( data )
	new tempname[ 32 ]; get_user_name( tempid, tempname, 31 )
	
	static motd[ 2500 ], len
	len = format( motd, sizeof( motd ) - 1,			"<body bgcolor=#10497d>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<table width=100%% cellpadding=2 cellspacing=4 border=4>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#52697B>" )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=10%% align=left>%s", tempname )
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=15%% align=center>Achievement Level" );
	len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<th width=20%% align=center>Achievement Max Level" )
	
	for( new iLevel = 20; iLevel < g_iAchCount; iLevel++ )
	{
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<tr align=center bgcolor=#c7c7c7>" )
		len += format( motd[ len ], sizeof( motd ) - len - 1,	"<td align=left>%s", g_iAchsMotd[ iLevel ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iAchLevel[ tempid ][ iLevel ] )
		len += format( motd[ len ], sizeof( motd ) - len - 1, 	"<td align=center>%i", g_iAchsMaxPoints[ iLevel ] )

	}
	len += format( motd[ len ], sizeof( motd ) - len - 1,	"</table></body>" )
	
	show_motd( id, motd, "Player Info" )
	menu_display( id, menu )
	menu_destroy( menu )
	return PLUGIN_HANDLED
}

public plugin_end()
{
	TrieDestroy( g_tWeaponNameToID )
	#if !defined USING_SQL
	nvault_close( g_iVault )
	#endif
}

public FwdPlayerSpawn(id)
{
	if( !is_user_alive( id ) )
	{
		return HAM_IGNORED
	}
	
	is_Alive[ id ] = true
	
	return HAM_IGNORED;
}

public client_connect( id )
{
	is_dead[ id ] = false
	ResetStats( id )
}

public client_authorized( id )
{
	if( !is_user_bot( id ) && !is_user_hltv( id ) )
	{
		#if defined USING_REGEX
		get_user_authid( id, g_iAuthID[ id ], charsmax( g_iAuthID[] ) - 1 )
		
		if( !IsValidAuthid( g_iAuthID[ id ] ) )
		{
			g_iAuthID[ id ][0] = 0
		}
		else
		{
			g_iLoadStats( id )
		}
		#else
		get_user_authid( id, g_iAuthID[ id ], charsmax( g_iAuthID[] ) )
		g_iLoadStats( id )
		#endif
	}
}

public client_putinserver( id )
{
	is_Connected[ id ] = bool:!is_user_hltv( id )
	if( is_Connected[ id ] )
	{
		#if defined USING_REGEX
		if( !IsUserAuthorized( id ) )
		{
			return PLUGIN_HANDLED
		}
		#endif
		g_iJoinTime[ id ] = get_systime()
		is_Alive[ id ] = false
		g_iDeathMessages[ id ] = true
		g_iAchLevel[ id ][ CONNECTIONS ]++
            
		new szName[ 32 ]
		get_user_name( id, szName, charsmax( szName ) )

		switch( g_iAchLevel[ id ][ CONNECTIONS ] )
		{
			case 100:
			{
				Print( 0, "%s^1 has earned ^3'^1I'll Be Back^3'^4 achievement!", szName )
				emit_sound( id, CHAN_ITEM, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				return PLUGIN_HANDLED
			}
            
			case 250:
			{
				Print( 0, "%s^1 has earned ^3'^1I Like This Server^3'^4 achievement!", szName )
				emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				return PLUGIN_HANDLED
			}
            
			case 500:
			{
				Print( 0, "%s^1 has earned ^3'^1Half Way There^3'^4 achievement!", szName )
				emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				return PLUGIN_HANDLED
			}
            
			case 1000:
			{
				Print( 0, "%s^1 has earned ^3'^1Ultimate Server Lover^3'^4 achievement!", szName )
				emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				return PLUGIN_HANDLED
			}
		}
	}
	return PLUGIN_HANDLED
}

public client_disconnect( id )
{
	g_iSaveStats( id )

	g_iJoinTime[ id ] = 0
	is_Connected[ id ] = false
	is_Alive[ id ] = false

	#if defined USING_SQL
	g_loaded_data[ id ] = 0
	#endif
}

public FwdCmdStart( id, handle )
{
	if ( !is_Connected[ id ] && !is_Alive[ id ] ) 
	{
		return FMRES_IGNORED
	}
	#if defined USING_REGEX
	if( !IsUserAuthorized( id ) )
	{
		return FMRES_IGNORED
	}
	#endif

	if( g_iAchLevel[ id ][ CAMP_FIRE ] <= 1 )
	{
		if( entity_get_int( id, EV_INT_button ) & ( IN_MOVELEFT | IN_MOVERIGHT | IN_BACK | IN_FORWARD ) )
		{
			iKillerHasNotMoved[ id ] = false
			g_iKills[ id ] = 0
		}
		else 
		{
			iKillerHasNotMoved[ id ] = true
		}
	}
	
	if( g_iAchLevel[ id ][ FLY_AWAY ] <= 1 )
	{
		if( entity_get_int( id, EV_INT_flags ) & FL_ONGROUND )
		{
			is_VictimInAir[ id ] = false
		}
		else
		{
			is_VictimInAir[ id ] = true
		}
	}
	
	if( g_iAchLevel[ id ][ DISTANCE_WALKED ] <= 2 && iKillerHasNotMoved[ id ] == false )
	{
		new Float:vecOrigin[ 3 ]
		entity_get_vector( id, EV_VEC_origin, vecOrigin )
	
		if( !xs_vec_equal( vecOldOrigin[ id ], vecNullOrigin ) )
		{
			flDistance[ id ] += get_distance_f( vecOrigin, vecOldOrigin[ id ] )
		}
		
		xs_vec_copy( vecOrigin, vecOldOrigin[ id ] )
		
		new szName[ 32 ]
		get_user_name( id, szName, charsmax( szName ) )
		
		switch( g_iAchLevel[ id ][ DISTANCE_WALKED ] )
		{
			case 0:
			{
				if( flDistance[ id ]/g_iFeet >= 1 )//baby steps
				{
					g_iAchLevel[ id ][ DISTANCE_WALKED ]++
					Print( 0, "%s^1 has earned ^3'^1Baby Foot Steps^3'^4 achievement!", szName )
					emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
			case 1:
			{
				if( flDistance[ id ]/g_iFeet >= 5280 )//1 mile hey?
				{
					g_iAchLevel[ id ][ DISTANCE_WALKED ]++
					Print( 0, "%s^1 has earned the ^3'^1I'm Half Way There^3'^4 achievement!", szName )
					emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
			case 2:
			{
				if( flDistance[ id ]/g_iFeet >= 52800 )//Ten miles hey? Is this possible IDK lol
				{
					g_iAchLevel[ id ][ DISTANCE_WALKED ]++
					Print( 0, "%s^1 has earned the ^3'^1Long Run^3'^4 achievement!", szName )
					emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
		}
	}
	
	new iPlayers[ 32 ], iNum, iPlayer, ctCount, tCount
	get_players( iPlayers, iNum, "ah" )
	
	for( new i = 0; i < iNum; i++ ) 
	{
		iPlayer = iPlayers[ i ]
		
		static CsTeams:iTeam
		iTeam = cs_get_user_team( iPlayers[ i ] )
		
		switch( iTeam )
		{
			case CS_TEAM_CT:
			{
				ctCount++
			}
			
			case CS_TEAM_T:
			{
				tCount++
			}
		}
	}
	
	if( ctCount == 1 || tCount == 1 )
	{
		StandAlone[ iPlayer ] = true
	}
	
	return FMRES_IGNORED
}

ResetStats( id )
{
	flDistance[ id ] = 0.0
	xs_vec_copy( vecNullOrigin, vecOldOrigin[ id ] )
}

public Event_NewRound()
{
	remove_task(0)
	
	if( get_pcvar_num( g_pCvar_ShowInfo ) == 1 )
	{
		if( g_iRounds >= 6 ) {
			Print( 0, "^1This server is using^3 Achievements^4 v%s^1, by^3 Pastout!", VERSION )
			Print( 0, "^1Type^3 /help^1 for information about^4 achievements")
			g_iRounds = 0
		}
		
		g_iRounds++
	}
	
	for( new i = 0; i < g_iMaxPlayers; i++ ) 
	{
		g_iTeamKills[ i ] = 0
		g_iRoundSparys[ i ] = 0
		StandAlone[ i ] = false
	}
	g_iBombPlant = false
	g_iGetBombPlanted = 26
	
	set_task(1.0, "CheckBombPlantedTimer", 0, _, _, "a", g_iGetBombPlanted )
}

public CheckBombPlantedTimer( )
{ 
	g_iGetBombPlanted--
	if( g_iGetBombPlanted >= 1 )
	{
		g_iGetBombDown = true
		
	} else {	
		g_iGetBombDown = false
		remove_task(0)
	}
}

public bomb_defused( iDefuser )
{
	#if defined USING_REGEX
	if( !IsUserAuthorized( iDefuser ) )
	{
		return PLUGIN_HANDLED
	}
	#endif
	new szName[ 32 ]
	get_user_name( iDefuser, szName, charsmax( szName ) )
	
	switch( g_iAchLevel[ iDefuser ][ BOMB ] )
	{
		case 0:
		{
			if( g_iBombPlant == true )
			{
				Print( 0, "%s^1 has earned ^3'^1OMFG that was close^3'^4 achievement!", szName ) 
				emit_sound( iDefuser, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
			g_iAchLevel[ iDefuser ][ BOMB ]++
		}
	}
	
	g_iAchLevel[ iDefuser ][ DEFUSED_BOMB ]++
	switch( g_iAchLevel[ iDefuser ][ DEFUSED_BOMB ] )
	{
		case 50: 
		{	
			Print( 0, "%s^1 has earned ^3'^1C4 Defuser^3'^4 achievement!", szName ) 
			emit_sound( iDefuser, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
		case 100: 
		{
			Print( 0, "%s^1 has earned ^3'^1That Was Easy^3'^4 achievement!", szName ) 
			emit_sound( iDefuser, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
		case 150: 
		{
			Print( 0, "%s^1 has earned ^3'^1Like a Game^3'^4 achievement!", szName ) 
			emit_sound( iDefuser, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
		case 200: 
		{
			Print( 0, "%s^1 has earned ^3'^1Master of C4^3'^4 achievement!", szName ) 
			emit_sound( iDefuser, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
		case 400: 
		{
			Print( 0, "%s^1 has earned ^3'^1Nothing Can Blow Up^3'^4 achievement!", szName ) 
			emit_sound( iDefuser, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
	}
	if( get_pcvar_num( g_pCvar_BombMessage ) == 1 )
	{
		Print( 0, "%s^1 has defused the^4 bomb.", szName ) 
	}
	#if defined USING_REGEX
	return PLUGIN_HANDLED
	#endif
}

public bomb_defusing( id )
{
	if( get_pcvar_num( g_pCvar_BombMessage ) == 1 )
	{
		new szName[ 32 ]
		get_user_name( id, szName, charsmax( szName ) )
		Print( 0, "%s^1 is defusing the^4 bomb^1 with%s a^3 kit^1.", szName, is_DefusingWithKit ? "" : "out" ) 
	}
}

public bomb_planting( id )
{
	if( get_pcvar_num( g_pCvar_BombMessage ) == 1 )
	{
		new szName[ 32 ]
		get_user_name( id, szName, charsmax( szName ) )
		Print( 0, "%s^1 is planting the^4 bomb.", szName ) 
	}
}

public bomb_planted( iPlanter )
{
	#if defined USING_REGEX
	if( !IsUserAuthorized( iPlanter ) )
	{
		return PLUGIN_HANDLED
	}
	#endif
	
	new szName[ 32 ]
	get_user_name( iPlanter, szName, charsmax( szName ) )
	
	g_iBombTime = get_pcvar_num( g_pCvarC4Timer )
	set_task(1.0, "CheckC4Timer", 0, _, _, "a", g_iBombTime )
	
	g_iAchLevel[ iPlanter ][ PLANT_BOMB_COUNT ]++

	if( is_Connected[ iPlanter ] && is_Alive[ iPlanter ] )
	{
		switch( g_iAchLevel[ iPlanter ][ PLANT_BOMB ] )
		{
			case 0:
			{
				if( g_iGetBombDown == true )
				{
					g_iAchLevel[ iPlanter ][ PLANT_BOMB ]++
					Print( 0, "%s^1 has earned ^3'^1Short Fuse^3'^4 achievement!", szName ) 
					emit_sound( iPlanter, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
		}
	
		switch( g_iAchLevel[ iPlanter ][ PLANT_BOMB_COUNT ]++ )
		{
			case 100:
			{
				Print( 0, "%s^1 has earned ^3'^1Boomala Boomala^3'^4 achievement!", szName ) 
				emit_sound( iPlanter, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}
	if( get_pcvar_num( g_pCvar_BombMessage ) == 1 )
	{
		Print( 0, "%s^1 has planted the^4 bomb.", szName ) 
	}
	#if defined USING_REGEX
	return PLUGIN_HANDLED
	#endif
}

public CheckC4Timer()
{ 
	g_iBombTime --
	if( g_iBombTime <= 1 )
	{
		g_iBombPlant = true
		remove_task(0)
	}
}

public Event_ResetHud( id )
{
	is_dead[ id ] = false
}

public Event_GotBomb( id )
{
	g_iPlanter = id
}

public bomb_explode( g_iPlayer )
{
	if( get_pcvar_num( g_pCvar_BombMessage ) == 1 )
	{
		Print( 0, "^1The^3 bomb^1 has^4 exploded." )  
	}
	if( g_iPlanter <= 0 ) return PLUGIN_CONTINUE
	set_task( 0.5, "check_dead", 9743248 )
	return PLUGIN_CONTINUE
}

public check_dead()
{
	new frags = 0
	new kname[ 32 ], kteam[ 10 ], kauthid[ 32 ]
	get_user_name( g_iPlanter, kname, 31 )
	get_user_team( g_iPlanter, kteam, 9 )
	get_user_authid( g_iPlanter, kauthid, 31 )

	new players[ 32 ], inum
	get_players( players, inum )
	for( new i = 0; i < inum; i++ )
	{
		new team = get_user_team( players[ i ] )
		if( is_Connected[ players[ i ] ] && !is_Alive[ players[ i ] ] && team != 0 && team != 3 )
		{
			if( !is_dead[ players[ i ] ] && team != get_user_team( g_iPlanter ) && players[ i ] != g_iPlanter )
			{
				++frags
				message_begin( MSG_BROADCAST, 83, {0,0,0}, 0 )
				write_byte( g_iPlanter )
				write_byte( players[ i ] )
				write_byte( 0 )
				write_string("c4")
				message_end()

				new vname[ 32 ], vteam[ 10 ], vauthid[ 32 ]

				get_user_name( players[ i ], vname, 31 )
				get_user_team( players[ i ], vteam, 9 )
				get_user_authid( players[ i ], vauthid, 31 )
		
				log_message("^"%s<%d><%s><%s>^" killed ^"%s<%d><%s><%s>^" with ^"%s^"", 
					kname, get_user_userid( g_iPlanter ), kauthid, kteam, 
 					vname, get_user_userid( players[ i ] ), vauthid, vteam, "c4" )
				g_iPlayersKills[ g_iPlanter ][ CSW_C4 ]++
				if( g_iPlayersKills[ g_iPlanter ][ CSW_C4 ] == 30 )
				{
					Print( 0, "%s^1 has earned ^3'^1C4 Killer^3'^4 achievement.", kname )
					emit_sound( g_iPlanter, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
		}
	}
	if( frags )
	{
		frags += get_user_frags( g_iPlanter )
		set_user_frags( g_iPlanter, frags )
	}
}

public client_death( iKiller, iVictim, iWeapon, iHitplace, TK )
{
	#if defined USING_REGEX
	if( !IsUserAuthorized( iKiller ) || !IsUserAuthorized( iVictim ) )
	{
		return PLUGIN_HANDLED
	}
	#endif
	
	new g_iKiller[ 32 ]
	get_user_name( iKiller, g_iKiller, charsmax( g_iKiller ) )
	if( ( iWeapon == CSW_HEGRENADE ) && !TK && is_Alive[ iKiller ] )
	{
		g_iPlayersKills[ iKiller ][ CSW_HEGRENADE ]++
		if( g_iPlayersKills[ iKiller ][ CSW_HEGRENADE ] == 300 )
		{
			Print( 0, "%s^1 has earned ^3'^1HE Grenade Expert^3'^4 achievement.", g_iKiller )
			emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
		
		g_iGrenadeKills[ iKiller ]++
		if( g_iGrenadeKills[ iKiller ] == 3 )
		{
			g_iAchLevel[ iKiller ][ HAT_TRICK ]++
			switch( g_iAchLevel[ iKiller ][ HAT_TRICK ] )
			{
				case 1:
				{
					g_iAchLevel[ iKiller ][ HAT_TRICK ]++
					Print( 0, "%s^1 has earned ^3'^1Hat Trick^3'^4 achievement!", g_iKiller ) 
					emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
			g_iGrenadeKills[ iKiller ] = 0
		}
		set_task( 0.3, "ResetGrenadeKills" )
	}
	#if defined USING_REGEX
	return PLUGIN_HANDLED
	#endif
}

public ResetGrenadeKills( )
{
	new iPlayers[ 32 ], iNum, iPlayer
	get_players( iPlayers, iNum, "ah" )
	
	for( new i = 0; i < iNum; i++ ) 
	{
		iPlayer = iPlayers[ i ]
	}
	g_iGrenadeKills[ iPlayer ] = 0
}

public grenade_throw( id, grenadeIndex, weaponId )
{
	#if defined USING_REGEX
	if( !IsUserAuthorized( id ) )
	{
		return PLUGIN_HANDLED
	}
	#endif
	
	new g_iName[ 32 ]
	get_user_name( id, g_iName, charsmax( g_iName ) )
	
	switch( weaponId )
	{
		case CSW_FLASHBANG:
		{
			g_iPlayersKills[ id ][ CSW_FLASHBANG ]++
			
			if( g_iPlayersKills[ id ][ CSW_FLASHBANG ] == 150 )
			{
				Print( 0, "%s^1 has earned ^3'^1Can You See?^3'^4 achievement!", g_iName ) 
				emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
		case CSW_SMOKEGRENADE:
		{
			g_iPlayersKills[ id ][ CSW_SMOKEGRENADE ]++
			
			if( g_iPlayersKills[ id ][ CSW_SMOKEGRENADE ] == 150 )
			{
				Print( 0, "%s^1 has earned ^3'^1It's A Bit Smokey In Here!^3'^4 achievement!", g_iName ) 
				emit_sound( id, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}
	#if defined USING_REGEX
	return PLUGIN_HANDLED
	#endif
}

public Event_PlayerKilled()
{
	new iKiller = read_data( 1 )
	new iVictim = read_data( 2 )
	
	is_dead[ iVictim ] = true
	
	is_Alive[ iKiller ] = bool:is_user_alive( iKiller )
	
	if( !IsPlayer( iKiller ) || iKiller == iVictim )
	{
		return PLUGIN_HANDLED
	}
	
//	if( get_pcvar_num( g_pCvar_FriendlyFire ) == 0 )
//	{
//		return PLUGIN_HANDLED
//	}
	#if defined USING_REGEX
	if( !IsUserAuthorized( iKiller ) || !IsUserAuthorized( iVictim ) )
	{
		return PLUGIN_HANDLED
	}
	#endif
	
	new headshot = read_data( 3 )
	new g_iKiller[ 32 ], g_iVictim[ 32 ], g_iWeapon[ 16 ], g_iOrigin[ 3 ], g_iOrigin2[ 3 ]
	read_data(4, g_iWeapon, 15)

	get_user_origin( iKiller, g_iOrigin )
	get_user_origin( iVictim, g_iOrigin2 )
	new flDistance = get_distance( g_iOrigin, g_iOrigin2 )
	
	get_user_name( iKiller, g_iKiller, charsmax( g_iKiller ) )
	get_user_name( iVictim, g_iVictim, charsmax( g_iVictim ) )
	
	if( iKillerShot[ iKiller ] == true )
	{
		g_iShotKills[ iKiller ]++
		if( g_iShotKills[ iKiller ] >= 2 )
		{
			g_iAchLevel[ iKiller ][ AMMO_CONSERVATION ]++
			switch( g_iAchLevel[ iKiller ][ AMMO_CONSERVATION ] )
			{
				case 1:
				{
					g_iAchLevel[ iKiller ][ AMMO_CONSERVATION ]++
					Print( 0, "%s^1 has earned ^3'^1Ammo Conservation^3'^4 achievement!", g_iKiller ) 
					emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
			g_iShotKills[ iKiller ] = 0 
		}
	}
	
	if( headshot )
	{
		
		g_iAchLevel[ iKiller ][ HEAD_SHOTS ]++
		
		switch( g_iAchLevel[ iKiller ][ HEAD_SHOTS ] )
		{
			case 300: 
			{
				Print( 0, "%s^1 has earned ^3'^1Boom Head-Shot^3'^4 achievement.", g_iKiller )
				emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}

	if( TrieGetCell( g_tWeaponNameToID, g_iWeapon, iWeaponID ) )
	{
		g_iPlayersKills[ iKiller ][ iWeaponID ]++

		switch( iWeaponID )
		{
			case CSW_P228:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 200: 
					{
						g_iAchLevel[ iKiller ][ PISTOL_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1228 Compact Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_SCOUT:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 1000: 
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Schmidt Scout Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}

			case CSW_XM1014:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 200: 
					{
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						g_iAchLevel[ iKiller ][ SHOTGUN_MASTER ]++
						Print( 0, "%s^1 has earned ^3'^1Leone YG1265 Auto Shotgun Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}

			case CSW_MAC10:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 500: 
					{
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Ingram Mac-10 Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_AUG:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 500:
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++	
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Bullpup Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
				
			}
			/*
			case CSW_SMOKEGRENADE:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{

				}
			}*/
			case CSW_ELITE:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 100:
					{
						g_iAchLevel[ iKiller ][ PISTOL_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1.40 Dual Elites Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_FIVESEVEN:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 100: 
					{
						g_iAchLevel[ iKiller ][ PISTOL_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1ES Five-Seven Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_UMP45:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 1000: 
					{
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1KM UMP45 Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_SG550:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 500: 
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1D3/AU-1 Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_GALIL:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 500: 
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1IDF Defender Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_FAMAS:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 500: 
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Clarion 5.56 Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_USP:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 200:
					{
						g_iAchLevel[ iKiller ][ PISTOL_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1KM Tactical .45 Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_GLOCK18:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 200:
					{
						g_iAchLevel[ iKiller ][ PISTOL_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1.919 Sidearm Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_AWP:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 1000:
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Magnum Sniper Rifle Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_MP5NAVY:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 1000: 
					{
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1KM Sub-Machine Gun Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_M249:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 500:
					{
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1M249 Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_M3:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 200: 
					{
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						g_iAchLevel[ iKiller ][ SHOTGUN_MASTER ]++
						Print( 0, "%s^1 has earned ^3'^1Leone 12 Gauge Super Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_M4A1:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 1000:
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Maverick M4A1 Carbine Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_TMP:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 1000: 
					{
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Schmidt Machine Pistol Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_G3SG1:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 500:
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Krieg 550 Commando Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			/*
			case CSW_FLASHBANG:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{

				}
			}*/
			case CSW_DEAGLE:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 200: 
					{
						g_iAchLevel[ iKiller ][ PISTOL_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Night Hawk .50c Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_SG552:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 500: 
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Krieg 552 Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_AK47:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 1000:
					{
						g_iAchLevel[ iKiller ][ RIFLE_MASTER ]++
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1CV-47 Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_KNIFE:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 200: 
					{
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1Knife Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
			case CSW_P90:
			{
				switch( g_iPlayersKills[ iKiller ][ iWeaponID ] )
				{
					case 1000: 
					{
						g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ]++
						Print( 0, "%s^1 has earned ^3'^1ES C90 Expert^3'^4 achievement.", g_iKiller )
						emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
					}
				}
			}
		}
	}

	if( floatround( flDistance/g_iFeet ) == 1 )
	{
		g_bFeet = false
	} else {
		g_bFeet = true
	}
		
	switch( g_iAchLevel[ iKiller ][ DISTANCE_KILLED ] )
	{
		case 0:
		{
			if( floatround( flDistance/g_iFeet ) <= 5 )
			{
				g_iAchLevel[ iKiller ][ DISTANCE_KILLED ]++
				Print( 0, "%s^1 has earned ^3'^1Short Range Kill^3'^4 achievement.", g_iKiller )
				emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
		
		case 1:
		{
			if( 6 <= floatround( flDistance/g_iFeet ) <= 50 )
			{
				g_iAchLevel[ iKiller ][ DISTANCE_KILLED ]++
				Print( 0, "%s^1 has earned ^3'^1Nice Aim^3'^4 achievement.", g_iKiller )
				emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}	
		}
		
		case 2:
		{
			if( 51 <= floatround( flDistance/g_iFeet ) <= 99 )
			{
				g_iAchLevel[ iKiller ][ DISTANCE_KILLED ]++
				Print( 0, "%s^1 has earned ^3'^1Long Range Kill^3'^4 achievement.", g_iKiller )
				emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
		
		case 3:
		{
			if( 100 <= floatround( flDistance/g_iFeet ) <= 150 )
			{
				g_iAchLevel[ iKiller ][ DISTANCE_KILLED ]++
				Print( 0, "%s^1 has earned ^3'^1Aim-Bot Time^3'^4 achievement.", g_iKiller )
				emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
		case 4:
		{
			if( 151 <= floatround( flDistance/g_iFeet ) <= 300 )
			{
				Print( 0, "%s^1 has earned ^3'^1I Got The Power^3'^4 achievement.", g_iKiller )
				emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}
	
	g_iAchLevel[ iKiller ][ TOTAL_KILLS ]++
	switch( g_iAchLevel[ iKiller ][ TOTAL_KILLS ] )
	{
		case 5000:
		{
			Print( 0, "%s^1 has earned ^3'^1Killer Master3'^4 achievement!", g_iKiller ) 
			emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
		case 10000:
		{
			Print( 0, "%s^1 has earned ^3'^1God of War^3'^4 achievement!", g_iKiller ) 
			emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
	}
	
	switch( g_iAchLevel[ iKiller ][ PISTOL_MASTER ] )
	{
		case 6:
		{
			Print( 0, "%s^1 has earned ^3'^1Pistol Master^3'^4 achievement!", g_iKiller ) 
			emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
	}

	switch( g_iAchLevel[ iKiller ][ RIFLE_MASTER ] )
	{
		case 10:
		{
			Print( 0, "%s^1 has earned ^3'^1Rifle Master^3'^4 achievement!", g_iKiller ) 
			emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
	}
	
	switch( g_iAchLevel[ iKiller ][ SHOTGUN_MASTER ] )
	{
		case 2:
		{
			Print( 0, "%s^1 has earned ^3'^1Shotgun Master^3'^4 achievement!", g_iKiller ) 
			emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
	}
	
	switch( g_iAchLevel[ iKiller ][ MASTER_AT_ARMS ] )
	{
		case 25:
		{
			Print( 0, "%s^1 has earned ^3'^1Master at Arms^3'^4 achievement!", g_iKiller ) 
			emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
	}
	
	if( is_VictimInAir[ iVictim ] == true )
	{
		g_iAchLevel[ iKiller ][ FLY_AWAY ]++
		switch( g_iAchLevel[ iKiller ][ FLY_AWAY ] )
		{
			case 1:
			{
				g_iAchLevel[ iKiller ][ FLY_AWAY ]++
				Print( 0, "%s^1 has earned ^3'^1Fly Away^3'^4 achievement!", g_iKiller ) 
				emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}
	
	new iPlayers[ 32 ], iNum, iPlayer
	get_players(iPlayers, iNum, "h")
	for( new i = 0; i < iNum; i++ ) 
	{
		 iPlayer = iPlayers[ i ]
	}
	
	new iPercent, iFlashAlpha
	if( ( iFlashAlpha = get_user_flashed( iKiller, iPercent ) ) )
	{
		if( get_pcvar_num( g_pCvar_FlashMessage ) == 1 )
		{
			Print( 0, "^3%s^4 was Flashed (^1%s^4) ^1%d%% and killed^4 %s", g_iKiller, iFlashAlpha == ALPHA_FULLBLINDED ? "Full" : "Semi", iPercent, g_iVictim )
		}
		if( iPercent == 100 )
		{
			g_iAchLevel[ iKiller ][ SPRAY_N_PRAY ]++
			
			switch( g_iAchLevel[ iKiller ][ SPRAY_N_PRAY ] )
			{
				case 1:
				{
					Print( 0, "%s^1 has earned ^3'^1Spray and Pray^3'^4 achievement!", g_iKiller ) 
					emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
		}

	}
	else
	{
		if( get_pcvar_num( g_pCvar_DeathMessage ) == 1 && g_iDeathMessages[ iPlayer ] == true )
		{
			Print( 0, "%s^4 %s^3 [^1 %s^3 ]^1 with a^4 %s^1 with a distance of^4 %d F%st^1 away.", g_iKiller, headshot ? "Headshot" : "Killed", g_iVictim, g_iWeapon, floatround( flDistance/g_iFeet ), g_bFeet ? "ee" : "oo" )
		}
	}

	if( StandAlone[ iVictim ] == true )
	{
		g_iAchLevel[ iVictim ][ STAND_ALONE ]++
		switch( g_iAchLevel[ iVictim ][ STAND_ALONE ] )
		{
			case 15:
			{
				g_iAchLevel[ iVictim ][ STAND_ALONE ]++
				Print( 0, "%s^1 has earned ^3'^1Stand Alone^3'^4 achievement!", g_iVictim ) 
				emit_sound( iVictim, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}
	
	if( get_user_health( iKiller ) == 1 )
	{
		OneHpHero[ iKiller ] = true
	}
	
	if( OneHpHero[ iKiller ] == true )
	{
		g_iAchLevel[ iKiller ][ ONE_HP_HERO ]++
		switch( g_iAchLevel[ iKiller ][ ONE_HP_HERO ] )
		{
			case 1:
			{
				g_iAchLevel[ iKiller ][ ONE_HP_HERO ]++
				Print( 0, "%s^1 has earned ^3'^1One Hp Hero^3'^4 achievement!", g_iKiller ) 
				emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}
	
	if( cs_get_user_team( iKiller ) == cs_get_user_team( iVictim ) )
	{
		g_iTeamKills[ iKiller ]++
	}
	
	if( g_iTeamKills[ iKiller ] == 5 )
	{
		g_iAchLevel[ iKiller ][ BAD_FRIEND ]++
		switch( g_iAchLevel[ iKiller ][ BAD_FRIEND ] )
		{
			case 1:
			{
				g_iAchLevel[ iKiller ][ BAD_FRIEND ]++
				Print( 0, "%s^1 has earned ^3'^1Bad Friend^3'^4 achievement!", g_iKiller ) 
				emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}
	
	if( iKillerHasNotMoved[ iKiller ] == true )
	{
		g_iKills[ iKiller ]++
		if( g_iKills[ iKiller ] == 3 )
		{
			
			g_iAchLevel[ iKiller ][ CAMP_FIRE ]++
			switch( g_iAchLevel[ iKiller ][ CAMP_FIRE ] )
			{
				case 1:
				{
					g_iAchLevel[ iKiller ][ CAMP_FIRE ]++
					Print( 0, "%s^1 has earned ^3'^1Camp Fire^3'^4 achievement!", g_iKiller ) 
					emit_sound( iKiller, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
				}
			}
		}
	}
	
	return PLUGIN_HANDLED
}

public Event_Spray( ) 
{ 
	new iPlayers[ 32 ], iNum, iPlayer
	get_players( iPlayers, iNum, "ah" )
	
	for( new i = 0; i < iNum; i++ ) 
	{
		iPlayer = iPlayers[ i ]
	}
	
	#if defined USING_REGEX
	if( !IsUserAuthorized( iPlayer ) )
	{
		return
	}
	#endif

	new szName[ 32 ]
	get_user_name( iPlayer, szName, charsmax( szName ) )
	
	g_iAchLevel[ iPlayer ][ URBAN_DESIGNER ]++
	switch( g_iAchLevel[ iPlayer ][ URBAN_DESIGNER ] )
	{
		case 300:
		{
			g_iAchLevel[ iPlayer ][ URBAN_DESIGNER ]++
			Print( 0, "%s^1 has earned ^3'^1Urban Designer^3'^4 achievement!", szName ) 
			emit_sound( iPlayer, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
		}
	}
	
	g_iRoundSparys[ iPlayer ]++
	
	if( g_iRoundSparys[ iPlayer ] == 8 )
	{
		g_iAchLevel[ iPlayer ][ GRAFFITI ]++
		switch( g_iAchLevel[ iPlayer ][ GRAFFITI ] )
		{
			case 1:
			{
				g_iAchLevel[ iPlayer ][ GRAFFITI ]++
				Print( 0, "%s^1 has earned ^3'^1Graffiti^3'^4 achievement!", szName ) 
				emit_sound( iPlayer, CHAN_STATIC, g_szAchievementSound, 1.0, ATTN_NORM, 0, PITCH_NORM )
			}
		}
	}
	#if defined USING_REGEX
	return
	#endif
}

get_user_flashed( id, &iPercent=0 )
{
	new Float:flFlashedAt = get_pdata_float( id, m_flFlashedAt, XO_PLAYER )
	
	if( !flFlashedAt )
	{
		return 0
	}
	
	new Float:flGameTime = get_gametime()
	new Float:flTimeLeft = flGameTime - flFlashedAt
	new Float:flFlashDuration = get_pdata_float( id, m_flFlashDuration, XO_PLAYER )
	new Float:flFlashHoldTime = get_pdata_float( id, m_flFlashHoldTime, XO_PLAYER )
	new Float:flTotalTime = flFlashHoldTime + flFlashDuration
	
	if( flTimeLeft > flTotalTime )
	{
		return 0
	}
	
	new iFlashAlpha = get_pdata_int( id, m_iFlashAlpha, XO_PLAYER )
	
	if( iFlashAlpha == ALPHA_FULLBLINDED )
	{
		if( get_pdata_float( id, m_flFlashedUntil, XO_PLAYER) - flGameTime > 0.0 )
		{
			iPercent = 100
		}
		else
		{
			iPercent = 100-floatround( ( ( flGameTime - ( flFlashedAt + flFlashHoldTime ) ) * 100.0 )/flFlashDuration )
		}
	}
	else
	{
		iPercent = 100-floatround( ( ( flGameTime - flFlashedAt ) * 100.0 ) / flTotalTime )
	}
	
	return iFlashAlpha
} 

Print( const client, const szMessageFormat[ ], any:... )
{
	static szMessage[ 192 ], iLen
	iLen = formatex( szMessage, 191, "^4[^1AMXX^4]^3 ")
	vformat( szMessage[ iLen ], 191 - iLen, szMessageFormat, 3 )
	
	if( client )
	{
		UTIL_SayText( client, client, szMessage )
	}
	else
	{
		static i
		for( i = 1; i <= MAX_PLAYERS; i++ )
		{
			if( is_Connected[ i ] )
			{
				UTIL_SayText( i, i, szMessage )
			}
		}
	}
}

UTIL_SayText( const iReceiver, const iSender, const szMessage[ ] )
{
	message_begin( iReceiver ? MSG_ONE_UNRELIABLE : MSG_BROADCAST, g_iMsgId_SayText, _, iReceiver )
	write_byte( iSender )
	write_string( szMessage )
	message_end( )
}

#if defined USING_REGEX
IsValidAuthid( authid[] )
{
	return ( regex_match_c( authid, g_SteamID_pattern, g_regex_return ) > 0 )
}

IsUserAuthorized( id )
{
	return g_iAuthID[ id ][ 0 ] != 0
}
#endif

public g_iLoadStats( id )
{
	#if defined USING_SQL
	static query[ 128 ]
	formatex(query, sizeof(query) - 1, "SELECT ^"data^" FROM ^"Achievement^" WHERE ^"authid^" = ^"%s^";", g_iAuthID[ id ] )
	
	static data[ 2 ]
	data[ 0 ] = id
	
	SQL_ThreadQuery( g_sql_tuple, "QueryLoadData", query, data, sizeof( data ) )

	#else
	static data[ 256 ], timestamp
	if( nvault_lookup( g_iVault, g_iAuthID[ id ], data, sizeof( data ) - 1, timestamp ) )
	{
		ParseLoadData( id, data )
		return//
	}
	else
	{
		NewUser( id )
	}
	#endif
}

public NewUser( id )
{
	
	for( new iLevel = 0; iLevel < g_iAchCount; iLevel++ )
	{
		g_iAchLevel[ id ][ iLevel ] = 0
	}

	for( new i = 0; i < WEAPON_SIZE; i++ )
	{
		g_iPlayersKills[ id ][ g_iWeaponIDs[ i ] ] = 0
	}

}

#if defined USING_SQL
public QueryLoadData( failstate, Handle:query, error[], errnum, data[], size, Float:queuetime )
{
	if( failstate == TQUERY_CONNECT_FAILED
	|| failstate == TQUERY_QUERY_FAILED )
	{
		set_fail_state( error )
	}
	else
	{
		if( SQL_NumResults( query ) )
		{
			static sqldata[ 256 ]
			SQL_ReadResult( query, 0, sqldata, sizeof( sqldata ) - 1 )
			ParseLoadData( data[0], sqldata )
		}
		else
		{
			NewUser( data[ 0 ] )
		}
	}
}
#endif

ParseLoadData( id, data[ 256 ] )
{
	new num[ 6 ]
	
	for( new i = 0; i < WEAPON_SIZE; i++ )
	{
		strbreak( data, num, sizeof( num ) - 1, data, sizeof( data ) - 1 )
		g_iPlayersKills[ id ][ g_iWeaponIDs[ i ] ] = clamp( str_to_num( num ), 0, g_iAchsWeaponMaxKills[ i ] )
	}
	
	for( new iLevel = 0; iLevel < g_iAchCount; iLevel++ )
	{
		strbreak( data, num, sizeof( num ) - 1, data, sizeof( data ) - 1 )
		g_iAchLevel[ id ][ iLevel ] = clamp( str_to_num( num ), 0, g_iAchsMaxPoints[ iLevel ] )
	}
	
	#if defined USING_SQL
	g_loaded_data[ id ] = 1
	#endif
}

public g_iSaveStats( id )
{
	#if defined USING_REGEX
	if( !IsUserAuthorized( id ) ) return
	#endif
	
	static data[ 256 ]
	new len
	
	for( new i = 0; i < WEAPON_SIZE; i++ )
	{
		len += formatex( data[ len ], sizeof( data ) - len - 1, " %i", g_iPlayersKills[ id ][ g_iWeaponIDs[ i ] ] )
	}
	
	for( new iLevel = 0; iLevel < g_iAchCount; iLevel++ )
	{
		len += formatex( data[ len ], sizeof( data ) - len - 1, " %i", g_iAchLevel[ id ][ iLevel ] )
	}
	
	#if defined USING_SQL
	static name[ 32 ]
	get_user_name( id, name, sizeof( name ) - 1 )

	static query[ 256 ]
	if( g_loaded_data[ id ] )
	{
		formatex( query, sizeof( query ) - 1, "UPDATE ^"Achievement^" SET ^"name^" = ^"%s^", ^"data^" = ^"%s^" WHERE ^"authid^" = ^"%s^";", name, data, g_iAuthID[ id ] )
	}
	else
	{
		formatex( query, sizeof( query ) - 1, "INSERT INTO ^"Achievement^" ( ^"name^", ^"authid^", ^"data^" ) VALUES ( ^"%s^", ^"%s^", ^"%s^" );", name, g_iAuthID[ id ], data )
	}
	
	SQL_ThreadQuery( g_sql_tuple, "QuerySaveData", query )
	#else
	nvault_set( g_iVault, g_iAuthID[ id ], data )
	#endif
}

#if defined USING_SQL
public QuerySaveData( failstate, Handle:query, error[], errnum, data[], size, Float:queuetime )
{
	if( failstate == TQUERY_CONNECT_FAILED
	|| failstate == TQUERY_QUERY_FAILED )
	{
		set_fail_state( error )
	}
}
#endif
