#include <amxmodx> 
#include <amxmisc>
#include <engine>
#include <cstrike>
#include <fun>
#include <fakemeta>

new NewEnt[33]
new lookin[33]
new bool:has_cam[33]
new bool:in_view[33]
new bool:is_t[33]

new g_func_breakable[] = "camera"

#define MAX_PLAYERS 32
new Float:g_time[MAX_PLAYERS + 1]

public plugin_init()
{
	register_plugin("Hidden camera", "1.0", "R3SP3CT")
	register_concmd("amx_camplace", "cmd_cam", ADMIN_SLAY, "")
	register_concmd("+camview","view_on")
	register_concmd("-camview","view_off")
	register_event("ResetHUD", "restart", "b")
	register_cvar("amx_cam","1")
	register_cvar("amx_cam_cost","5000")
	register_cvar("amx_cam_hp","100.0")
	register_cvar("amx_cam_reward","1000")
	register_forward ( FM_TraceLine, "forward_trace_line" )
	register_forward(FM_Think, "forward_think")
}

public plugin_precache() 
{
	precache_model("models/rshell.mdl")
	precache_sound("items/suitchargeok1.wav")
	precache_sound("debris/bustglass1.wav")
	precache_sound("debris/bustglass2.wav")
	precache_sound("debris/bustglass3.wav")
	
	return PLUGIN_CONTINUE 
}

public client_disconnect(id) {
	remove_entity(NewEnt[id])
	remove_entity(lookin[id])
	lookin[id] = 0
	NewEnt[id] = 0
}

public restart(id) {
	in_view[id] = false
	has_cam[id] = false
	remove_entity(NewEnt[id])
	remove_entity(lookin[id])
	lookin[id] = 0
	NewEnt[id] = 0
}

public cmd_cam(id)
{
	if(get_cvar_num("amx_cam") != 1) {
		return PLUGIN_HANDLED
		}
	if (has_cam[id] == true) {
		client_print(id, print_chat, "You can place only one cam in a round!")
		return PLUGIN_HANDLED
	}
	if (!is_user_connected(id) || !is_user_alive(id))
	{
		return PLUGIN_HANDLED
	}
	if (get_cvar_num("amx_cam_cost") < 0 || get_cvar_num("amx_cam_cost") > 16000)
	{
		set_cvar_num("amx_cam_cost",5000)
	}
	new Float:vNormal[3]
	new Float:vTraceDirection[3]
	new Float:vTraceEnd[3]
	new Float:vOrigin[3]
	new Float:vEntAngles[3]
	new Float:vTraceResult[3]
	
	entity_get_vector(id, EV_VEC_origin, vOrigin)
	vOrigin[2] = vOrigin[2] + 17
	velocity_by_aim(id, 64, vTraceDirection)

	vTraceEnd[0] = vTraceDirection[0] + vOrigin[0]
	vTraceEnd[1] = vTraceDirection[1] + vOrigin[1]
	vTraceEnd[2] = vTraceDirection[2] + vOrigin[2]
	
	if(trace_normal(id, vOrigin, vTraceEnd, vNormal) == 0){
		client_print(id, print_chat, "There's no wall! Cam must be placed on a wall!")
		return PLUGIN_HANDLED
	}
	else if(trace_line(id, vOrigin, vTraceEnd, vTraceResult) != 0) {
		client_print(id, print_chat, "You can't place camera here!")
		return PLUGIN_HANDLED
	}
	else if(cs_get_user_money(id) < get_cvar_num("amx_cam_cost")) {
		client_print(id, print_chat, "You can't afford hidden camera! Cost: $%i",get_cvar_num("amx_cam_cost"))
		return PLUGIN_HANDLED
	}
	NewEnt[id] = create_entity("func_breakable")
	lookin[id] = create_entity("info_target")

	entity_set_string(NewEnt[id], EV_SZ_classname, "camera")
	entity_set_string(lookin[id], EV_SZ_classname, "look")
	
	entity_set_int(NewEnt[id], EV_INT_movetype, 5) //5 = movetype_fly, No grav, but collides.
	entity_set_int(lookin[id], EV_INT_movetype, 5)
	entity_set_int(NewEnt[id], EV_INT_solid, 4)
	entity_set_int(lookin[id], EV_INT_solid, 0)
	entity_set_model(NewEnt[id], "models/rshell.mdl")
	entity_set_model(lookin[id], "models/rshell.mdl")
		
	entity_set_float(NewEnt[id], EV_FL_frame, 0.0)
	entity_set_float(lookin[id], EV_FL_frame, 0.0)
	entity_set_int(NewEnt[id], EV_INT_body, 3)
	entity_set_int(lookin[id], EV_INT_body, 3)
	entity_set_int(NewEnt[id], EV_INT_sequence, 0)
	entity_set_int(lookin[id], EV_INT_sequence, 0)
	entity_set_float(NewEnt[id], EV_FL_framerate, 0.0)
	entity_set_float(lookin[id], EV_FL_framerate, 0.0)
		
	entity_set_origin(NewEnt[id], vTraceResult)
	entity_set_origin(lookin[id], vTraceResult)
	vector_to_angle(vNormal, vEntAngles)
	
	entity_set_vector(NewEnt[id], EV_VEC_angles, vEntAngles)
	
	vEntAngles[0] = vEntAngles[0] - (vEntAngles[0] * 2)

	entity_set_vector(lookin[id], EV_VEC_angles, vEntAngles)
	entity_set_int(lookin[id], EV_INT_rendermode, 2)
	entity_set_float(lookin[id], EV_FL_renderamt, 0.0)
	
	entity_set_float(NewEnt[id], EV_FL_takedamage, 100.0)
	entity_set_float(NewEnt[id], EV_FL_dmg_take, 100.0)
	
	if(get_cvar_float("amx_cam_hp") <= 0.0)
	{
		set_cvar_float("amx_cam_hp",100.0)
	}
	entity_set_float(NewEnt[id], EV_FL_health, get_cvar_float("amx_cam_hp"))
	
	entity_set_size(NewEnt[id], Float:{-0.1,-0.1,-0.1}, Float:{0.1,0.1,0.1})

	emit_sound(NewEnt[id], CHAN_WEAPON, "items/suitchargeok1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	
	cs_set_user_money (id,cs_get_user_money(id)-get_cvar_num("amx_cam_cost"),1) 
	
	if (cs_get_user_team(id) == CS_TEAM_T)
	{
		set_rendering(NewEnt[id],kRenderFxGlowShell,255,0,0,kRenderNormal,5)
		is_t[id] = true
	}
	else if (cs_get_user_team(id) == CS_TEAM_CT)
	{
		set_rendering(NewEnt[id],kRenderFxGlowShell,0,0,255,kRenderNormal,5)
		is_t[id] = false
	}

	has_cam[id] = true		
	return PLUGIN_HANDLED
}

public view_on(id)
{
	if (lookin[id] != 0 && is_user_alive(id)) {
		attach_view(id, lookin[id])
		in_view[id] = true
	}
}
public view_off(id)
{
	attach_view( id, id )
	in_view[id] = false
}

public client_PreThink(id) {
	if(get_cvar_num("amx_cam") != 1) {
		if(lookin[id] != 0 || NewEnt[id] !=0) {
			remove_entity(lookin[id])
			remove_entity(NewEnt[id])
			lookin[id]=0
			NewEnt[id]=0
			attach_view(id, id)
			has_cam[id] = false
		}
	}
	if(in_view[id] && get_user_button ( id ) & IN_ATTACK) {
		attach_view(id,id)
	}
	if(in_view[id] && get_user_button ( id ) & IN_ATTACK2) {
		attach_view(id,id)
	}
	return PLUGIN_CONTINUE
}

public forward_think(ent) {
	if (!is_breakable(ent) || !pev(ent, pev_deadflag))
		return FMRES_IGNORED  
	new own
	new i
	for(i = 1;i<=32;++i) {
		if(NewEnt[i] == ent) {
			own = i
		}
	}
	new id
	new Float:maxtime
	for (new i = 1; i <= MAX_PLAYERS; ++i) {
        if (g_time[i] > maxtime) {
            maxtime = g_time[i]
            id = i
        }
    }

	client_print(own, print_chat, "Your cam is destroyed!")
	remove_entity(lookin[own])
	remove_entity(NewEnt[own])
	lookin[own]=0
	NewEnt[own]=0
	attach_view(own, own)
	if(is_t[own] && cs_get_user_team(id) == CS_TEAM_CT) {
		if (cs_get_user_money(id) > 16000 - get_cvar_num("amx_cam_reward")) {
			cs_set_user_money(id,16000,1)
		}
		else {
			cs_set_user_money(id,cs_get_user_money(id)+get_cvar_num("amx_cam_reward"),1)
		}
	}
	else if(!is_t[own] && cs_get_user_team(id) == CS_TEAM_T) {
		if (cs_get_user_money(id) > 16000 - get_cvar_num("amx_cam_reward")) {
			cs_set_user_money(id,16000,1)
		}
		else {
			cs_set_user_money(id,cs_get_user_money(id)+get_cvar_num("amx_cam_reward"),1)
		}
	}
	else{
		if(cs_get_user_money(id) < get_cvar_num("amx_cam_reward")*2) {
			cs_set_user_money(id,0,1)
		}
		else {
			cs_set_user_money(id,cs_get_user_money(id)-(get_cvar_num("amx_cam_reward")*2),1)
		}
	}
	return FMRES_IGNORED
}

public forward_trace_line(const Float:start[3], const Float:dest[3], ignore_monsters, skip_ent, ptr) {
    if (!skip_ent || !is_user_alive(skip_ent))
        return FMRES_IGNORED

    new phit = get_tr2(ptr, TR_pHit)
    if (!pev_valid(phit) || !is_breakable(phit))
        return FMRES_IGNORED

    g_time[skip_ent] = get_gametime()

    return FMRES_IGNORED
}

bool:is_breakable(ent) {
    new class[16]
    pev(ent, pev_classname, class, 15)
    if (equal(class, g_func_breakable))
        return true
    
    return false
}