/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <fakemeta_util>
#include <zombieplague>
#include <hamsandwich>

#define PLUGIN "[ZP] DM Item's"
#define VERSION "0.1.2"
#define AUTHOR "PomanoB"

#define OFFSET_FLASH_AMMO 387
#define OFFSET_HE_AMMO 388
#define OFFSET_SMOKE_AMMO 389

new g_Menu

new g_MapFile[64]

new const item_class_name[] = "dm_item"

new g_models[][] = {"models/presentlg.mdl", "models/presentsm.mdl"}

new const g_desription[9][] = {"Получил ночное видение", "Пополнил здоровье",
	"Получил кредитов", "Нашел Броню", "Получил гранаты",
	"Получил sg500!", "Получил g3sg1!", "Получил m249!", "Нашел Антивирус"}

public plugin_precache()
{
	for (new i = 0; i < sizeof g_models; i++)
		precache_model(g_models[i])	
}

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_forward(FM_Touch, "fwd_Touch")
	
	register_event("HLTV", "round_start", "a", "1=0", "2=0")
	
	register_clcmd("say /imenu", "display_items_menu", ADMIN_CFG, " - display item's menu")
	
	g_Menu = menu_create("DM Item's Меню","menu_item")
	
	menu_additem(g_Menu, "Добавить", "1")
	menu_additem(g_Menu, "Удалить", "2")
	menu_additem(g_Menu, "Удалить все", "3")
	menu_additem(g_Menu, "Возродить все", "4")
	menu_additem(g_Menu, "Сохранить", "5")
	
}

public plugin_cfg()
{
	new map[32], config[32]
	
	get_mapname(map, 31)
	get_configsdir(config, 31)
	
	format(g_MapFile, 63, "%s/dm_items",config, map)
	if (!dir_exists(g_MapFile))
		mkdir(g_MapFile)
	
	format(g_MapFile, 63, "%s/%s.cfg",config, map)

	if (file_exists(g_MapFile))

	
	if (file_exists(g_MapFile)) 
	{
		new data[124], len
		new line = 0
		new coord[3][8]
		new origin[3]
				
		while((line = read_file(g_MapFile , line , data , 123 , len))) 
		{
			if (len < 2 || data[0] == ';' || data[0] == '/') 
				continue
			
			parse(data, coord[0], 7, coord[1], 7, coord[2], 7)
			
			origin[0] = str_to_num(coord[0])
			origin[1] = str_to_num(coord[1])
			origin[2] = str_to_num(coord[2])
			
			addItem(origin)
		}
	}
	else
		log_amx("Can't find cfg file for this map")
}

public display_items_menu(id, level, cid)
{
	if (cmd_access(id, level, cid, 0))
		menu_display(id, g_Menu, 0)
	return PLUGIN_HANDLED
}

public menu_item(id, menu, item)
{
	if( item < 0 ) 
		return PLUGIN_CONTINUE
 
	new cmd[3]
	new maccess, callback
 
	menu_item_getinfo(menu, item, maccess, cmd,2,_,_, callback)
	new iChoice = str_to_num(cmd)
	
	switch(iChoice)
	{
		case 1:
		{
			new origin[3]
			get_user_origin(id, origin, 3)
			addItem(origin)
		}
		case 2:
			deleteItem(id)
		case 3:
			deleteAllItems()
		case 4:
			round_start()
		case 5:
			saveAll()
	}
	menu_display(id, g_Menu, 0)
	
	return PLUGIN_CONTINUE
}

public addItem(origin[3])
{
	new ent = fm_create_entity("info_target")
	set_pev(ent, pev_classname, item_class_name)
	
	engfunc(EngFunc_SetModel,ent, g_models[random_num(0, sizeof g_models - 1)])

	set_pev(ent,pev_mins,Float:{-10.0,-10.0,0.0})
	set_pev(ent,pev_maxs,Float:{10.0,10.0,25.0})
	set_pev(ent,pev_size,Float:{-10.0,-10.0,0.0,10.0,10.0,25.0})
	engfunc(EngFunc_SetSize,ent,Float:{-10.0,-10.0,0.0},Float:{10.0,10.0,25.0})

	set_pev(ent,pev_solid,SOLID_BBOX)
	set_pev(ent,pev_movetype,MOVETYPE_FLY)
	
	new Float:fOrigin[3]
	IVecFVec(origin, fOrigin)
	set_pev(ent, pev_origin, fOrigin)
	
	set_pev(ent,pev_renderfx,kRenderFxGlowShell)
	switch(random_num(1,4))
	{
		case 1: set_pev(ent,pev_rendercolor,Float:{0.0,0.0,255.0})
		case 2: set_pev(ent,pev_rendercolor,Float:{0.0,255.0,0.0})
		case 3: set_pev(ent,pev_rendercolor,Float:{255.0,0.0,0.0})
		case 4: set_pev(ent,pev_rendercolor,Float:{255.0,255.0,255.0})
	}
}

public deleteItem(id)
{
	new ent, a_body
	get_user_aiming(id, ent, a_body)
	if (!pev_valid(ent))
		return PLUGIN_CONTINUE
		
	new class[32]
	pev(ent, pev_classname, class, 31)
	if (!equal(class, item_class_name))
		return PLUGIN_CONTINUE
	
	set_pev(ent, pev_flags, FL_KILLME)
	
	return PLUGIN_CONTINUE
}


public deleteAllItems()
{
	new ent = FM_NULLENT
	static string_class[] = "classname"
	while ((ent = engfunc(EngFunc_FindEntityByString, ent, string_class, item_class_name))) 
		set_pev(ent, pev_flags, FL_KILLME)
	
	delete_file(g_MapFile)
}

public saveAll()
{
	delete_file(g_MapFile)
	
	new ent = FM_NULLENT
	static string_class[] = "classname"
	
	new origin[3], Float:fOrigin[3], line[64]
	
	while ((ent = engfunc(EngFunc_FindEntityByString, ent, string_class, item_class_name))) 
	{
		pev(ent, pev_origin, fOrigin)
		
		FVecIVec(fOrigin, origin)
		
		formatex(line, 63, "%d %d %d", origin[0], origin[1], origin[2])
		write_file(g_MapFile, line)
	}
}

public fwd_Touch(toucher, touched)
{
	if (!is_user_alive(toucher) || !pev_valid(touched))
		return FMRES_IGNORED
	
	new classname[32]	
	pev(touched, pev_classname, classname, 31)
	if (!equal(classname, item_class_name))
		return FMRES_IGNORED
	
	
	
	give_item(toucher)
	set_pev(touched, pev_effects, EF_NODRAW)
	set_pev(touched, pev_solid, SOLID_NOT)
	
	return FMRES_IGNORED
	
}

public removeEntity(ent)
{
	if (pev_valid(ent))
		engfunc(EngFunc_RemoveEntity, ent)
}

public give_item(id)
{
	new zombie 
	zombie = zp_get_user_zombie(id)
	
	new i = random_num(0, (zombie ? 2 : 7))
	switch (i)
	{
		case 0:
			if (zombie)
			{
				if (!zp_get_user_last_zombie(id) && !zp_is_survivor_round() && !zp_is_swarm_round())
				{
					zp_disinfect_user(id)
				}
				
			}
			else
			{
				if (!zp_get_user_nightvision(id))
				{
					zp_set_user_nightvision(id, 1)
				}
				
			}
			
		case 1:
			fm_set_user_health(id, get_user_health(id) + (zombie ? 2000 : 500))
		case 2:
			add_ammo(id, 20)
		case 3:
			fm_set_user_armor(id, get_user_armor(id) + 200)
		case 4:
		{
			fm_give_item(id, "weapon_flashbang")
			fm_give_item(id, "weapon_smokegrenade")
			fm_give_item(id, "weapon_hegrenade")
			
			set_pdata_int(id, OFFSET_FLASH_AMMO, 3)
			set_pdata_int(id, OFFSET_HE_AMMO, 3)
			set_pdata_int(id, OFFSET_SMOKE_AMMO, 3)
		}
		case 5:
			if (!user_has_weapon(id, CSW_SG550))
			{
				fm_give_item(id, "weapon_sg550")
				ExecuteHamB(Ham_GiveAmmo, id, 30, "556nato", 90)
			}
		case 6:
			if (!user_has_weapon(id, CSW_G3SG1))
			{
				fm_give_item(id, "weapon_g3sg1")
				ExecuteHamB(Ham_GiveAmmo, id, 30, "762nato", 20)
			}
		case 7:
			if (!user_has_weapon(id, CSW_M249))
			{
				fm_give_item(id, "weapon_m249")
				ExecuteHamB(Ham_GiveAmmo, id, 100, "9mm", 200)
			}
	
	}
	if (i || !zombie)
		client_print(id, print_chat, "[ZP] %s", g_desription[i])
	else
		client_print(id, print_chat, "[ZP] %s", g_desription[8])
}

public round_start()
{	
	new ent = FM_NULLENT
	static string_class[] = "classname"
	while ((ent = engfunc(EngFunc_FindEntityByString, ent, string_class, item_class_name)))
	{
		set_pev(ent, pev_effects, 0)
		set_pev(ent, pev_solid, SOLID_BBOX)
	}
}

public add_ammo(id, count)
{
	zp_set_user_ammo_packs(id, zp_get_user_ammo_packs(id) + count)
	new pluginid = is_plugin_loaded("[ZP] Stats")
	if (pluginid != -1) 
	{
		new filename[64]
		get_plugin(pluginid, filename, 63)
	
		if (callfunc_begin("zp_stats_add_packs", filename) == 1)
		{
			callfunc_push_int(id)
			callfunc_push_int(count)
			callfunc_end()
		}
	}
}
